/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.medicalimaging.DefaultMedicalImagingAsyncClientBuilder;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClientBuilder;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingServiceClientConfiguration;
import software.amazon.awssdk.services.medicalimaging.model.CopyImageSetRequest;
import software.amazon.awssdk.services.medicalimaging.model.CopyImageSetResponse;
import software.amazon.awssdk.services.medicalimaging.model.CreateDatastoreRequest;
import software.amazon.awssdk.services.medicalimaging.model.CreateDatastoreResponse;
import software.amazon.awssdk.services.medicalimaging.model.DeleteDatastoreRequest;
import software.amazon.awssdk.services.medicalimaging.model.DeleteDatastoreResponse;
import software.amazon.awssdk.services.medicalimaging.model.DeleteImageSetRequest;
import software.amazon.awssdk.services.medicalimaging.model.DeleteImageSetResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetDatastoreRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetDatastoreResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetDicomImportJobRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetDicomImportJobResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetImageFrameRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetImageFrameResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetMetadataRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetMetadataResponse;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetRequest;
import software.amazon.awssdk.services.medicalimaging.model.GetImageSetResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsResponse;
import software.amazon.awssdk.services.medicalimaging.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsRequest;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsResponse;
import software.amazon.awssdk.services.medicalimaging.model.StartDicomImportJobRequest;
import software.amazon.awssdk.services.medicalimaging.model.StartDicomImportJobResponse;
import software.amazon.awssdk.services.medicalimaging.model.TagResourceRequest;
import software.amazon.awssdk.services.medicalimaging.model.TagResourceResponse;
import software.amazon.awssdk.services.medicalimaging.model.UntagResourceRequest;
import software.amazon.awssdk.services.medicalimaging.model.UntagResourceResponse;
import software.amazon.awssdk.services.medicalimaging.model.UpdateImageSetMetadataRequest;
import software.amazon.awssdk.services.medicalimaging.model.UpdateImageSetMetadataResponse;
import software.amazon.awssdk.services.medicalimaging.paginators.ListDICOMImportJobsPublisher;
import software.amazon.awssdk.services.medicalimaging.paginators.ListDatastoresPublisher;
import software.amazon.awssdk.services.medicalimaging.paginators.ListImageSetVersionsPublisher;
import software.amazon.awssdk.services.medicalimaging.paginators.SearchImageSetsPublisher;

@SdkPublicApi
@ThreadSafe
public interface MedicalImagingAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "medical-imaging";
    public static final String SERVICE_METADATA_ID = "medical-imaging";

    default public CompletableFuture<CopyImageSetResponse> copyImageSet(CopyImageSetRequest copyImageSetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CopyImageSetResponse> copyImageSet(Consumer<CopyImageSetRequest.Builder> copyImageSetRequest) {
        return this.copyImageSet((CopyImageSetRequest)((Object)((CopyImageSetRequest.Builder)CopyImageSetRequest.builder().applyMutation(copyImageSetRequest)).build()));
    }

    default public CompletableFuture<CreateDatastoreResponse> createDatastore(CreateDatastoreRequest createDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateDatastoreResponse> createDatastore(Consumer<CreateDatastoreRequest.Builder> createDatastoreRequest) {
        return this.createDatastore((CreateDatastoreRequest)((Object)((CreateDatastoreRequest.Builder)CreateDatastoreRequest.builder().applyMutation(createDatastoreRequest)).build()));
    }

    default public CompletableFuture<DeleteDatastoreResponse> deleteDatastore(DeleteDatastoreRequest deleteDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteDatastoreResponse> deleteDatastore(Consumer<DeleteDatastoreRequest.Builder> deleteDatastoreRequest) {
        return this.deleteDatastore((DeleteDatastoreRequest)((Object)((DeleteDatastoreRequest.Builder)DeleteDatastoreRequest.builder().applyMutation(deleteDatastoreRequest)).build()));
    }

    default public CompletableFuture<DeleteImageSetResponse> deleteImageSet(DeleteImageSetRequest deleteImageSetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteImageSetResponse> deleteImageSet(Consumer<DeleteImageSetRequest.Builder> deleteImageSetRequest) {
        return this.deleteImageSet((DeleteImageSetRequest)((Object)((DeleteImageSetRequest.Builder)DeleteImageSetRequest.builder().applyMutation(deleteImageSetRequest)).build()));
    }

    default public CompletableFuture<GetDicomImportJobResponse> getDICOMImportJob(GetDicomImportJobRequest getDicomImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDicomImportJobResponse> getDICOMImportJob(Consumer<GetDicomImportJobRequest.Builder> getDicomImportJobRequest) {
        return this.getDICOMImportJob((GetDicomImportJobRequest)((Object)((GetDicomImportJobRequest.Builder)GetDicomImportJobRequest.builder().applyMutation(getDicomImportJobRequest)).build()));
    }

    default public CompletableFuture<GetDatastoreResponse> getDatastore(GetDatastoreRequest getDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDatastoreResponse> getDatastore(Consumer<GetDatastoreRequest.Builder> getDatastoreRequest) {
        return this.getDatastore((GetDatastoreRequest)((Object)((GetDatastoreRequest.Builder)GetDatastoreRequest.builder().applyMutation(getDatastoreRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> getImageFrame(GetImageFrameRequest getImageFrameRequest, AsyncResponseTransformer<GetImageFrameResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getImageFrame(Consumer<GetImageFrameRequest.Builder> getImageFrameRequest, AsyncResponseTransformer<GetImageFrameResponse, ReturnT> asyncResponseTransformer) {
        return this.getImageFrame((GetImageFrameRequest)((Object)((GetImageFrameRequest.Builder)GetImageFrameRequest.builder().applyMutation(getImageFrameRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetImageFrameResponse> getImageFrame(GetImageFrameRequest getImageFrameRequest, Path destinationPath) {
        return this.getImageFrame(getImageFrameRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetImageFrameResponse> getImageFrame(Consumer<GetImageFrameRequest.Builder> getImageFrameRequest, Path destinationPath) {
        return this.getImageFrame((GetImageFrameRequest)((Object)((GetImageFrameRequest.Builder)GetImageFrameRequest.builder().applyMutation(getImageFrameRequest)).build()), destinationPath);
    }

    default public CompletableFuture<GetImageSetResponse> getImageSet(GetImageSetRequest getImageSetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetImageSetResponse> getImageSet(Consumer<GetImageSetRequest.Builder> getImageSetRequest) {
        return this.getImageSet((GetImageSetRequest)((Object)((GetImageSetRequest.Builder)GetImageSetRequest.builder().applyMutation(getImageSetRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> getImageSetMetadata(GetImageSetMetadataRequest getImageSetMetadataRequest, AsyncResponseTransformer<GetImageSetMetadataResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getImageSetMetadata(Consumer<GetImageSetMetadataRequest.Builder> getImageSetMetadataRequest, AsyncResponseTransformer<GetImageSetMetadataResponse, ReturnT> asyncResponseTransformer) {
        return this.getImageSetMetadata((GetImageSetMetadataRequest)((Object)((GetImageSetMetadataRequest.Builder)GetImageSetMetadataRequest.builder().applyMutation(getImageSetMetadataRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetImageSetMetadataResponse> getImageSetMetadata(GetImageSetMetadataRequest getImageSetMetadataRequest, Path destinationPath) {
        return this.getImageSetMetadata(getImageSetMetadataRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetImageSetMetadataResponse> getImageSetMetadata(Consumer<GetImageSetMetadataRequest.Builder> getImageSetMetadataRequest, Path destinationPath) {
        return this.getImageSetMetadata((GetImageSetMetadataRequest)((Object)((GetImageSetMetadataRequest.Builder)GetImageSetMetadataRequest.builder().applyMutation(getImageSetMetadataRequest)).build()), destinationPath);
    }

    default public CompletableFuture<ListDicomImportJobsResponse> listDICOMImportJobs(ListDicomImportJobsRequest listDicomImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListDicomImportJobsResponse> listDICOMImportJobs(Consumer<ListDicomImportJobsRequest.Builder> listDicomImportJobsRequest) {
        return this.listDICOMImportJobs((ListDicomImportJobsRequest)((Object)((ListDicomImportJobsRequest.Builder)ListDicomImportJobsRequest.builder().applyMutation(listDicomImportJobsRequest)).build()));
    }

    default public ListDICOMImportJobsPublisher listDICOMImportJobsPaginator(ListDicomImportJobsRequest listDicomImportJobsRequest) {
        return new ListDICOMImportJobsPublisher(this, listDicomImportJobsRequest);
    }

    default public ListDICOMImportJobsPublisher listDICOMImportJobsPaginator(Consumer<ListDicomImportJobsRequest.Builder> listDicomImportJobsRequest) {
        return this.listDICOMImportJobsPaginator((ListDicomImportJobsRequest)((Object)((ListDicomImportJobsRequest.Builder)ListDicomImportJobsRequest.builder().applyMutation(listDicomImportJobsRequest)).build()));
    }

    default public CompletableFuture<ListDatastoresResponse> listDatastores(ListDatastoresRequest listDatastoresRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListDatastoresResponse> listDatastores(Consumer<ListDatastoresRequest.Builder> listDatastoresRequest) {
        return this.listDatastores((ListDatastoresRequest)((Object)((ListDatastoresRequest.Builder)ListDatastoresRequest.builder().applyMutation(listDatastoresRequest)).build()));
    }

    default public ListDatastoresPublisher listDatastoresPaginator(ListDatastoresRequest listDatastoresRequest) {
        return new ListDatastoresPublisher(this, listDatastoresRequest);
    }

    default public ListDatastoresPublisher listDatastoresPaginator(Consumer<ListDatastoresRequest.Builder> listDatastoresRequest) {
        return this.listDatastoresPaginator((ListDatastoresRequest)((Object)((ListDatastoresRequest.Builder)ListDatastoresRequest.builder().applyMutation(listDatastoresRequest)).build()));
    }

    default public CompletableFuture<ListImageSetVersionsResponse> listImageSetVersions(ListImageSetVersionsRequest listImageSetVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListImageSetVersionsResponse> listImageSetVersions(Consumer<ListImageSetVersionsRequest.Builder> listImageSetVersionsRequest) {
        return this.listImageSetVersions((ListImageSetVersionsRequest)((Object)((ListImageSetVersionsRequest.Builder)ListImageSetVersionsRequest.builder().applyMutation(listImageSetVersionsRequest)).build()));
    }

    default public ListImageSetVersionsPublisher listImageSetVersionsPaginator(ListImageSetVersionsRequest listImageSetVersionsRequest) {
        return new ListImageSetVersionsPublisher(this, listImageSetVersionsRequest);
    }

    default public ListImageSetVersionsPublisher listImageSetVersionsPaginator(Consumer<ListImageSetVersionsRequest.Builder> listImageSetVersionsRequest) {
        return this.listImageSetVersionsPaginator((ListImageSetVersionsRequest)((Object)((ListImageSetVersionsRequest.Builder)ListImageSetVersionsRequest.builder().applyMutation(listImageSetVersionsRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<SearchImageSetsResponse> searchImageSets(SearchImageSetsRequest searchImageSetsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchImageSetsResponse> searchImageSets(Consumer<SearchImageSetsRequest.Builder> searchImageSetsRequest) {
        return this.searchImageSets((SearchImageSetsRequest)((Object)((SearchImageSetsRequest.Builder)SearchImageSetsRequest.builder().applyMutation(searchImageSetsRequest)).build()));
    }

    default public SearchImageSetsPublisher searchImageSetsPaginator(SearchImageSetsRequest searchImageSetsRequest) {
        return new SearchImageSetsPublisher(this, searchImageSetsRequest);
    }

    default public SearchImageSetsPublisher searchImageSetsPaginator(Consumer<SearchImageSetsRequest.Builder> searchImageSetsRequest) {
        return this.searchImageSetsPaginator((SearchImageSetsRequest)((Object)((SearchImageSetsRequest.Builder)SearchImageSetsRequest.builder().applyMutation(searchImageSetsRequest)).build()));
    }

    default public CompletableFuture<StartDicomImportJobResponse> startDICOMImportJob(StartDicomImportJobRequest startDicomImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartDicomImportJobResponse> startDICOMImportJob(Consumer<StartDicomImportJobRequest.Builder> startDicomImportJobRequest) {
        return this.startDICOMImportJob((StartDicomImportJobRequest)((Object)((StartDicomImportJobRequest.Builder)StartDicomImportJobRequest.builder().applyMutation(startDicomImportJobRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateImageSetMetadataResponse> updateImageSetMetadata(UpdateImageSetMetadataRequest updateImageSetMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateImageSetMetadataResponse> updateImageSetMetadata(Consumer<UpdateImageSetMetadataRequest.Builder> updateImageSetMetadataRequest) {
        return this.updateImageSetMetadata((UpdateImageSetMetadataRequest)((Object)((UpdateImageSetMetadataRequest.Builder)UpdateImageSetMetadataRequest.builder().applyMutation(updateImageSetMetadataRequest)).build()));
    }

    default public MedicalImagingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static MedicalImagingAsyncClient create() {
        return (MedicalImagingAsyncClient)MedicalImagingAsyncClient.builder().build();
    }

    public static MedicalImagingAsyncClientBuilder builder() {
        return new DefaultMedicalImagingAsyncClientBuilder();
    }
}

