/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medicalimaging.model.LosslessStorageFormat;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingRequest;
import software.amazon.awssdk.services.medicalimaging.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatastoreRequest
extends MedicalImagingRequest
implements ToCopyableBuilder<Builder, CreateDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreName").getter(CreateDatastoreRequest.getter(CreateDatastoreRequest::datastoreName)).setter(CreateDatastoreRequest.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDatastoreRequest.getter(CreateDatastoreRequest::clientToken)).setter(CreateDatastoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDatastoreRequest.getter(CreateDatastoreRequest::tags)).setter(CreateDatastoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateDatastoreRequest.getter(CreateDatastoreRequest::kmsKeyArn)).setter(CreateDatastoreRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> LAMBDA_AUTHORIZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaAuthorizerArn").getter(CreateDatastoreRequest.getter(CreateDatastoreRequest::lambdaAuthorizerArn)).setter(CreateDatastoreRequest.setter(Builder::lambdaAuthorizerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerArn").build()}).build();
    private static final SdkField<String> LOSSLESS_STORAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("losslessStorageFormat").getter(CreateDatastoreRequest.getter(CreateDatastoreRequest::losslessStorageFormatAsString)).setter(CreateDatastoreRequest.setter(Builder::losslessStorageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("losslessStorageFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD, LAMBDA_AUTHORIZER_ARN_FIELD, LOSSLESS_STORAGE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDatastoreRequest.memberNameToFieldInitializer();
    private final String datastoreName;
    private final String clientToken;
    private final Map<String, String> tags;
    private final String kmsKeyArn;
    private final String lambdaAuthorizerArn;
    private final String losslessStorageFormat;

    private CreateDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lambdaAuthorizerArn = builder.lambdaAuthorizerArn;
        this.losslessStorageFormat = builder.losslessStorageFormat;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String lambdaAuthorizerArn() {
        return this.lambdaAuthorizerArn;
    }

    public final LosslessStorageFormat losslessStorageFormat() {
        return LosslessStorageFormat.fromValue(this.losslessStorageFormat);
    }

    public final String losslessStorageFormatAsString() {
        return this.losslessStorageFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaAuthorizerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.losslessStorageFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatastoreRequest)) {
            return false;
        }
        CreateDatastoreRequest other = (CreateDatastoreRequest)((Object)obj);
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.lambdaAuthorizerArn(), other.lambdaAuthorizerArn()) && Objects.equals(this.losslessStorageFormatAsString(), other.losslessStorageFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatastoreRequest").add("DatastoreName", (Object)this.datastoreName()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("LambdaAuthorizerArn", (Object)this.lambdaAuthorizerArn()).add("LosslessStorageFormat", (Object)this.losslessStorageFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "lambdaAuthorizerArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaAuthorizerArn()));
            }
            case "losslessStorageFormat": {
                return Optional.ofNullable(clazz.cast(this.losslessStorageFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datastoreName", DATASTORE_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("lambdaAuthorizerArn", LAMBDA_AUTHORIZER_ARN_FIELD);
        map.put("losslessStorageFormat", LOSSLESS_STORAGE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatastoreRequest, T> g) {
        return obj -> g.apply((CreateDatastoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingRequest.BuilderImpl
    implements Builder {
        private String datastoreName;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;
        private String lambdaAuthorizerArn;
        private String losslessStorageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatastoreRequest model) {
            super(model);
            this.datastoreName(model.datastoreName);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.kmsKeyArn(model.kmsKeyArn);
            this.lambdaAuthorizerArn(model.lambdaAuthorizerArn);
            this.losslessStorageFormat(model.losslessStorageFormat);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getLambdaAuthorizerArn() {
            return this.lambdaAuthorizerArn;
        }

        public final void setLambdaAuthorizerArn(String lambdaAuthorizerArn) {
            this.lambdaAuthorizerArn = lambdaAuthorizerArn;
        }

        @Override
        public final Builder lambdaAuthorizerArn(String lambdaAuthorizerArn) {
            this.lambdaAuthorizerArn = lambdaAuthorizerArn;
            return this;
        }

        public final String getLosslessStorageFormat() {
            return this.losslessStorageFormat;
        }

        public final void setLosslessStorageFormat(String losslessStorageFormat) {
            this.losslessStorageFormat = losslessStorageFormat;
        }

        @Override
        public final Builder losslessStorageFormat(String losslessStorageFormat) {
            this.losslessStorageFormat = losslessStorageFormat;
            return this;
        }

        @Override
        public final Builder losslessStorageFormat(LosslessStorageFormat losslessStorageFormat) {
            this.losslessStorageFormat(losslessStorageFormat == null ? null : losslessStorageFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatastoreRequest build() {
            return new CreateDatastoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MedicalImagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatastoreRequest> {
        public Builder datastoreName(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);

        public Builder lambdaAuthorizerArn(String var1);

        public Builder losslessStorageFormat(String var1);

        public Builder losslessStorageFormat(LosslessStorageFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

