/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetState;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetWorkflowStatus;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.services.medicalimaging.model.Overrides;
import software.amazon.awssdk.services.medicalimaging.model.StorageTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImageSetResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, GetImageSetResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(GetImageSetResponse.getter(GetImageSetResponse::datastoreId)).setter(GetImageSetResponse.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()}).build();
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(GetImageSetResponse.getter(GetImageSetResponse::imageSetId)).setter(GetImageSetResponse.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionId").getter(GetImageSetResponse.getter(GetImageSetResponse::versionId)).setter(GetImageSetResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetState").getter(GetImageSetResponse.getter(GetImageSetResponse::imageSetStateAsString)).setter(GetImageSetResponse.setter(Builder::imageSetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()}).build();
    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetWorkflowStatus").getter(GetImageSetResponse.getter(GetImageSetResponse::imageSetWorkflowStatusAsString)).setter(GetImageSetResponse.setter(Builder::imageSetWorkflowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetImageSetResponse.getter(GetImageSetResponse::createdAt)).setter(GetImageSetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetImageSetResponse.getter(GetImageSetResponse::updatedAt)).setter(GetImageSetResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deletedAt").getter(GetImageSetResponse.getter(GetImageSetResponse::deletedAt)).setter(GetImageSetResponse.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(GetImageSetResponse.getter(GetImageSetResponse::message)).setter(GetImageSetResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> IMAGE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetArn").getter(GetImageSetResponse.getter(GetImageSetResponse::imageSetArn)).setter(GetImageSetResponse.setter(Builder::imageSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetArn").build()}).build();
    private static final SdkField<Overrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(GetImageSetResponse.getter(GetImageSetResponse::overrides)).setter(GetImageSetResponse.setter(Builder::overrides)).constructor(Overrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Boolean> IS_PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPrimary").getter(GetImageSetResponse.getter(GetImageSetResponse::isPrimary)).setter(GetImageSetResponse.setter(Builder::isPrimary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimary").build()}).build();
    private static final SdkField<Instant> LAST_ACCESSED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAccessedAt").getter(GetImageSetResponse.getter(GetImageSetResponse::lastAccessedAt)).setter(GetImageSetResponse.setter(Builder::lastAccessedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccessedAt").build()}).build();
    private static final SdkField<String> STORAGE_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageTier").getter(GetImageSetResponse.getter(GetImageSetResponse::storageTierAsString)).setter(GetImageSetResponse.setter(Builder::storageTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, IMAGE_SET_ID_FIELD, VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DELETED_AT_FIELD, MESSAGE_FIELD, IMAGE_SET_ARN_FIELD, OVERRIDES_FIELD, IS_PRIMARY_FIELD, LAST_ACCESSED_AT_FIELD, STORAGE_TIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetImageSetResponse.memberNameToFieldInitializer();
    private final String datastoreId;
    private final String imageSetId;
    private final String versionId;
    private final String imageSetState;
    private final String imageSetWorkflowStatus;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant deletedAt;
    private final String message;
    private final String imageSetArn;
    private final Overrides overrides;
    private final Boolean isPrimary;
    private final Instant lastAccessedAt;
    private final String storageTier;

    private GetImageSetResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.versionId = builder.versionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.deletedAt = builder.deletedAt;
        this.message = builder.message;
        this.imageSetArn = builder.imageSetArn;
        this.overrides = builder.overrides;
        this.isPrimary = builder.isPrimary;
        this.lastAccessedAt = builder.lastAccessedAt;
        this.storageTier = builder.storageTier;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(this.imageSetState);
    }

    public final String imageSetStateAsString() {
        return this.imageSetState;
    }

    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(this.imageSetWorkflowStatus);
    }

    public final String imageSetWorkflowStatusAsString() {
        return this.imageSetWorkflowStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public final String message() {
        return this.message;
    }

    public final String imageSetArn() {
        return this.imageSetArn;
    }

    public final Overrides overrides() {
        return this.overrides;
    }

    public final Boolean isPrimary() {
        return this.isPrimary;
    }

    public final Instant lastAccessedAt() {
        return this.lastAccessedAt;
    }

    public final StorageTier storageTier() {
        return StorageTier.fromValue(this.storageTier);
    }

    public final String storageTierAsString() {
        return this.storageTier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrimary());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageSetResponse)) {
            return false;
        }
        GetImageSetResponse other = (GetImageSetResponse)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.imageSetStateAsString(), other.imageSetStateAsString()) && Objects.equals(this.imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.deletedAt(), other.deletedAt()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.imageSetArn(), other.imageSetArn()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.isPrimary(), other.isPrimary()) && Objects.equals(this.lastAccessedAt(), other.lastAccessedAt()) && Objects.equals(this.storageTierAsString(), other.storageTierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetImageSetResponse").add("DatastoreId", (Object)this.datastoreId()).add("ImageSetId", (Object)this.imageSetId()).add("VersionId", (Object)this.versionId()).add("ImageSetState", (Object)this.imageSetStateAsString()).add("ImageSetWorkflowStatus", (Object)this.imageSetWorkflowStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DeletedAt", (Object)this.deletedAt()).add("Message", (Object)this.message()).add("ImageSetArn", (Object)this.imageSetArn()).add("Overrides", (Object)this.overrides()).add("IsPrimary", (Object)this.isPrimary()).add("LastAccessedAt", (Object)this.lastAccessedAt()).add("StorageTier", (Object)this.storageTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "imageSetState": {
                return Optional.ofNullable(clazz.cast(this.imageSetStateAsString()));
            }
            case "imageSetWorkflowStatus": {
                return Optional.ofNullable(clazz.cast(this.imageSetWorkflowStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "deletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "imageSetArn": {
                return Optional.ofNullable(clazz.cast(this.imageSetArn()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "isPrimary": {
                return Optional.ofNullable(clazz.cast(this.isPrimary()));
            }
            case "lastAccessedAt": {
                return Optional.ofNullable(clazz.cast(this.lastAccessedAt()));
            }
            case "storageTier": {
                return Optional.ofNullable(clazz.cast(this.storageTierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("imageSetId", IMAGE_SET_ID_FIELD);
        map.put("versionId", VERSION_ID_FIELD);
        map.put("imageSetState", IMAGE_SET_STATE_FIELD);
        map.put("imageSetWorkflowStatus", IMAGE_SET_WORKFLOW_STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("deletedAt", DELETED_AT_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("imageSetArn", IMAGE_SET_ARN_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        map.put("isPrimary", IS_PRIMARY_FIELD);
        map.put("lastAccessedAt", LAST_ACCESSED_AT_FIELD);
        map.put("storageTier", STORAGE_TIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImageSetResponse, T> g) {
        return obj -> g.apply((GetImageSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String imageSetId;
        private String versionId;
        private String imageSetState;
        private String imageSetWorkflowStatus;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant deletedAt;
        private String message;
        private String imageSetArn;
        private Overrides overrides;
        private Boolean isPrimary;
        private Instant lastAccessedAt;
        private String storageTier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageSetResponse model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.imageSetId(model.imageSetId);
            this.versionId(model.versionId);
            this.imageSetState(model.imageSetState);
            this.imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.deletedAt(model.deletedAt);
            this.message(model.message);
            this.imageSetArn(model.imageSetArn);
            this.overrides(model.overrides);
            this.isPrimary(model.isPrimary);
            this.lastAccessedAt(model.lastAccessedAt);
            this.storageTier(model.storageTier);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getImageSetState() {
            return this.imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return this.imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getImageSetArn() {
            return this.imageSetArn;
        }

        public final void setImageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
        }

        @Override
        public final Builder imageSetArn(String imageSetArn) {
            this.imageSetArn = imageSetArn;
            return this;
        }

        public final Overrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        public final void setOverrides(Overrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(Overrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final Boolean getIsPrimary() {
            return this.isPrimary;
        }

        public final void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public final Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public final Instant getLastAccessedAt() {
            return this.lastAccessedAt;
        }

        public final void setLastAccessedAt(Instant lastAccessedAt) {
            this.lastAccessedAt = lastAccessedAt;
        }

        @Override
        public final Builder lastAccessedAt(Instant lastAccessedAt) {
            this.lastAccessedAt = lastAccessedAt;
            return this;
        }

        public final String getStorageTier() {
            return this.storageTier;
        }

        public final void setStorageTier(String storageTier) {
            this.storageTier = storageTier;
        }

        @Override
        public final Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        @Override
        public final Builder storageTier(StorageTier storageTier) {
            this.storageTier(storageTier == null ? null : storageTier.toString());
            return this;
        }

        @Override
        public GetImageSetResponse build() {
            return new GetImageSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImageSetResponse> {
        public Builder datastoreId(String var1);

        public Builder imageSetId(String var1);

        public Builder versionId(String var1);

        public Builder imageSetState(String var1);

        public Builder imageSetState(ImageSetState var1);

        public Builder imageSetWorkflowStatus(String var1);

        public Builder imageSetWorkflowStatus(ImageSetWorkflowStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder deletedAt(Instant var1);

        public Builder message(String var1);

        public Builder imageSetArn(String var1);

        public Builder overrides(Overrides var1);

        default public Builder overrides(Consumer<Overrides.Builder> overrides) {
            return this.overrides((Overrides)((Overrides.Builder)Overrides.builder().applyMutation(overrides)).build());
        }

        public Builder isPrimary(Boolean var1);

        public Builder lastAccessedAt(Instant var1);

        public Builder storageTier(String var1);

        public Builder storageTier(StorageTier var1);
    }
}

