/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.AuthenticationMode;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.Tag;
import software.amazon.awssdk.services.memorydb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(CreateUserRequest.getter(CreateUserRequest::userName)).setter(CreateUserRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<AuthenticationMode> AUTHENTICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationMode").getter(CreateUserRequest.getter(CreateUserRequest::authenticationMode)).setter(CreateUserRequest.setter(Builder::authenticationMode)).constructor(AuthenticationMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build()}).build();
    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessString").getter(CreateUserRequest.getter(CreateUserRequest::accessString)).setter(CreateUserRequest.setter(Builder::accessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateUserRequest.getter(CreateUserRequest::tags)).setter(CreateUserRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, AUTHENTICATION_MODE_FIELD, ACCESS_STRING_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateUserRequest.memberNameToFieldInitializer();
    private final String userName;
    private final AuthenticationMode authenticationMode;
    private final String accessString;
    private final List<Tag> tags;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.authenticationMode = builder.authenticationMode;
        this.accessString = builder.accessString;
        this.tags = builder.tags;
    }

    public final String userName() {
        return this.userName;
    }

    public final AuthenticationMode authenticationMode() {
        return this.authenticationMode;
    }

    public final String accessString() {
        return this.accessString;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.authenticationMode(), other.authenticationMode()) && Objects.equals(this.accessString(), other.accessString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserRequest").add("UserName", (Object)this.userName()).add("AuthenticationMode", (Object)this.authenticationMode()).add("AccessString", (Object)this.accessString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "AuthenticationMode": {
                return Optional.ofNullable(clazz.cast(this.authenticationMode()));
            }
            case "AccessString": {
                return Optional.ofNullable(clazz.cast(this.accessString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("AuthenticationMode", AUTHENTICATION_MODE_FIELD);
        map.put("AccessString", ACCESS_STRING_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String userName;
        private AuthenticationMode authenticationMode;
        private String accessString;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            this.userName(model.userName);
            this.authenticationMode(model.authenticationMode);
            this.accessString(model.accessString);
            this.tags(model.tags);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final AuthenticationMode.Builder getAuthenticationMode() {
            return this.authenticationMode != null ? this.authenticationMode.toBuilder() : null;
        }

        public final void setAuthenticationMode(AuthenticationMode.BuilderImpl authenticationMode) {
            this.authenticationMode = authenticationMode != null ? authenticationMode.build() : null;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        public final String getAccessString() {
            return this.accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder userName(String var1);

        public Builder authenticationMode(AuthenticationMode var1);

        default public Builder authenticationMode(Consumer<AuthenticationMode.Builder> authenticationMode) {
            return this.authenticationMode((AuthenticationMode)((AuthenticationMode.Builder)AuthenticationMode.builder().applyMutation(authenticationMode)).build());
        }

        public Builder accessString(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

