/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.MultiRegionCluster;
import software.amazon.awssdk.services.memorydb.model.MultiRegionClusterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMultiRegionClustersResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeMultiRegionClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMultiRegionClustersResponse.getter(DescribeMultiRegionClustersResponse::nextToken)).setter(DescribeMultiRegionClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MultiRegionCluster>> MULTI_REGION_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiRegionClusters").getter(DescribeMultiRegionClustersResponse.getter(DescribeMultiRegionClustersResponse::multiRegionClusters)).setter(DescribeMultiRegionClustersResponse.setter(Builder::multiRegionClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MULTI_REGION_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMultiRegionClustersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MultiRegionCluster> multiRegionClusters;

    private DescribeMultiRegionClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.multiRegionClusters = builder.multiRegionClusters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMultiRegionClusters() {
        return this.multiRegionClusters != null && !(this.multiRegionClusters instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionCluster> multiRegionClusters() {
        return this.multiRegionClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiRegionClusters() ? this.multiRegionClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionClustersResponse)) {
            return false;
        }
        DescribeMultiRegionClustersResponse other = (DescribeMultiRegionClustersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMultiRegionClusters() == other.hasMultiRegionClusters() && Objects.equals(this.multiRegionClusters(), other.multiRegionClusters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMultiRegionClustersResponse").add("NextToken", (Object)this.nextToken()).add("MultiRegionClusters", this.hasMultiRegionClusters() ? this.multiRegionClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MultiRegionClusters": {
                return Optional.ofNullable(clazz.cast(this.multiRegionClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MultiRegionClusters", MULTI_REGION_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionClustersResponse, T> g) {
        return obj -> g.apply((DescribeMultiRegionClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MultiRegionCluster> multiRegionClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionClustersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.multiRegionClusters(model.multiRegionClusters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MultiRegionCluster.Builder> getMultiRegionClusters() {
            List<MultiRegionCluster.Builder> result = MultiRegionClusterListCopier.copyToBuilder(this.multiRegionClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiRegionClusters(Collection<MultiRegionCluster.BuilderImpl> multiRegionClusters) {
            this.multiRegionClusters = MultiRegionClusterListCopier.copyFromBuilder(multiRegionClusters);
        }

        @Override
        public final Builder multiRegionClusters(Collection<MultiRegionCluster> multiRegionClusters) {
            this.multiRegionClusters = MultiRegionClusterListCopier.copy(multiRegionClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionClusters(MultiRegionCluster ... multiRegionClusters) {
            this.multiRegionClusters(Arrays.asList(multiRegionClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionClusters(Consumer<MultiRegionCluster.Builder> ... multiRegionClusters) {
            this.multiRegionClusters(Stream.of(multiRegionClusters).map(c -> (MultiRegionCluster)((MultiRegionCluster.Builder)MultiRegionCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMultiRegionClustersResponse build() {
            return new DescribeMultiRegionClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMultiRegionClustersResponse> {
        public Builder nextToken(String var1);

        public Builder multiRegionClusters(Collection<MultiRegionCluster> var1);

        public Builder multiRegionClusters(MultiRegionCluster ... var1);

        public Builder multiRegionClusters(Consumer<MultiRegionCluster.Builder> ... var1);
    }
}

