/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.MultiRegionParameter;
import software.amazon.awssdk.services.memorydb.model.MultiRegionParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMultiRegionParametersResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeMultiRegionParametersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMultiRegionParametersResponse.getter(DescribeMultiRegionParametersResponse::nextToken)).setter(DescribeMultiRegionParametersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MultiRegionParameter>> MULTI_REGION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiRegionParameters").getter(DescribeMultiRegionParametersResponse.getter(DescribeMultiRegionParametersResponse::multiRegionParameters)).setter(DescribeMultiRegionParametersResponse.setter(Builder::multiRegionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MULTI_REGION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMultiRegionParametersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MultiRegionParameter> multiRegionParameters;

    private DescribeMultiRegionParametersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.multiRegionParameters = builder.multiRegionParameters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMultiRegionParameters() {
        return this.multiRegionParameters != null && !(this.multiRegionParameters instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionParameter> multiRegionParameters() {
        return this.multiRegionParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiRegionParameters() ? this.multiRegionParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionParametersResponse)) {
            return false;
        }
        DescribeMultiRegionParametersResponse other = (DescribeMultiRegionParametersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMultiRegionParameters() == other.hasMultiRegionParameters() && Objects.equals(this.multiRegionParameters(), other.multiRegionParameters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMultiRegionParametersResponse").add("NextToken", (Object)this.nextToken()).add("MultiRegionParameters", this.hasMultiRegionParameters() ? this.multiRegionParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MultiRegionParameters": {
                return Optional.ofNullable(clazz.cast(this.multiRegionParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MultiRegionParameters", MULTI_REGION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionParametersResponse, T> g) {
        return obj -> g.apply((DescribeMultiRegionParametersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MultiRegionParameter> multiRegionParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionParametersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.multiRegionParameters(model.multiRegionParameters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MultiRegionParameter.Builder> getMultiRegionParameters() {
            List<MultiRegionParameter.Builder> result = MultiRegionParametersListCopier.copyToBuilder(this.multiRegionParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiRegionParameters(Collection<MultiRegionParameter.BuilderImpl> multiRegionParameters) {
            this.multiRegionParameters = MultiRegionParametersListCopier.copyFromBuilder(multiRegionParameters);
        }

        @Override
        public final Builder multiRegionParameters(Collection<MultiRegionParameter> multiRegionParameters) {
            this.multiRegionParameters = MultiRegionParametersListCopier.copy(multiRegionParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionParameters(MultiRegionParameter ... multiRegionParameters) {
            this.multiRegionParameters(Arrays.asList(multiRegionParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionParameters(Consumer<MultiRegionParameter.Builder> ... multiRegionParameters) {
            this.multiRegionParameters(Stream.of(multiRegionParameters).map(c -> (MultiRegionParameter)((MultiRegionParameter.Builder)MultiRegionParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMultiRegionParametersResponse build() {
            return new DescribeMultiRegionParametersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMultiRegionParametersResponse> {
        public Builder nextToken(String var1);

        public Builder multiRegionParameters(Collection<MultiRegionParameter> var1);

        public Builder multiRegionParameters(MultiRegionParameter ... var1);

        public Builder multiRegionParameters(Consumer<MultiRegionParameter.Builder> ... var1);
    }
}

