/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.memorydb.model.ShardConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShardDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShardDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ShardDetail.getter(ShardDetail::name)).setter(ShardDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ShardConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(ShardDetail.getter(ShardDetail::configuration)).setter(ShardDetail.setter(Builder::configuration)).constructor(ShardConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Size").getter(ShardDetail.getter(ShardDetail::size)).setter(ShardDetail.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SnapshotCreationTime").getter(ShardDetail.getter(ShardDetail::snapshotCreationTime)).setter(ShardDetail.setter(Builder::snapshotCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_FIELD, SIZE_FIELD, SNAPSHOT_CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ShardDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ShardConfiguration configuration;
    private final String size;
    private final Instant snapshotCreationTime;

    private ShardDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.size = builder.size;
        this.snapshotCreationTime = builder.snapshotCreationTime;
    }

    public final String name() {
        return this.name;
    }

    public final ShardConfiguration configuration() {
        return this.configuration;
    }

    public final String size() {
        return this.size;
    }

    public final Instant snapshotCreationTime() {
        return this.snapshotCreationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardDetail)) {
            return false;
        }
        ShardDetail other = (ShardDetail)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.snapshotCreationTime(), other.snapshotCreationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ShardDetail").add("Name", (Object)this.name()).add("Configuration", (Object)this.configuration()).add("Size", (Object)this.size()).add("SnapshotCreationTime", (Object)this.snapshotCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "SnapshotCreationTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("SnapshotCreationTime", SNAPSHOT_CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShardDetail, T> g) {
        return obj -> g.apply((ShardDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ShardConfiguration configuration;
        private String size;
        private Instant snapshotCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardDetail model) {
            this.name(model.name);
            this.configuration(model.configuration);
            this.size(model.size);
            this.snapshotCreationTime(model.snapshotCreationTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ShardConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ShardConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ShardConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getSize() {
            return this.size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        public final Instant getSnapshotCreationTime() {
            return this.snapshotCreationTime;
        }

        public final void setSnapshotCreationTime(Instant snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
        }

        @Override
        public final Builder snapshotCreationTime(Instant snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
            return this;
        }

        public ShardDetail build() {
            return new ShardDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShardDetail> {
        public Builder name(String var1);

        public Builder configuration(ShardConfiguration var1);

        default public Builder configuration(Consumer<ShardConfiguration.Builder> configuration) {
            return this.configuration((ShardConfiguration)((ShardConfiguration.Builder)ShardConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder size(String var1);

        public Builder snapshotCreationTime(Instant var1);
    }
}

