/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.internal.UserAgentUtils;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeMultiRegionClustersResponse;
import software.amazon.awssdk.services.memorydb.model.MultiRegionCluster;

public class DescribeMultiRegionClustersPublisher
implements SdkPublisher<DescribeMultiRegionClustersResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeMultiRegionClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMultiRegionClustersPublisher(MemoryDbAsyncClient client, DescribeMultiRegionClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMultiRegionClustersPublisher(MemoryDbAsyncClient client, DescribeMultiRegionClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMultiRegionClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMultiRegionClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MultiRegionCluster> multiRegionClusters() {
        Function<DescribeMultiRegionClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiRegionClusters() != null) {
                return response.multiRegionClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMultiRegionClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMultiRegionClustersResponseFetcher
    implements AsyncPageFetcher<DescribeMultiRegionClustersResponse> {
        private DescribeMultiRegionClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMultiRegionClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMultiRegionClustersResponse> nextPage(DescribeMultiRegionClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeMultiRegionClustersPublisher.this.client.describeMultiRegionClusters(DescribeMultiRegionClustersPublisher.this.firstRequest);
            }
            return DescribeMultiRegionClustersPublisher.this.client.describeMultiRegionClusters((DescribeMultiRegionClustersRequest)((Object)DescribeMultiRegionClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

