/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source Server connector action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceServerConnectorAction implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceServerConnectorAction.Builder, SourceServerConnectorAction> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorArn").getter(getter(SourceServerConnectorAction::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(SourceServerConnectorAction::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorArn;

    private final String credentialsSecretArn;

    private SourceServerConnectorAction(BuilderImpl builder) {
        this.connectorArn = builder.connectorArn;
        this.credentialsSecretArn = builder.credentialsSecretArn;
    }

    /**
     * <p>
     * Source Server connector action connector arn.
     * </p>
     * 
     * @return Source Server connector action connector arn.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * Source Server connector action credentials secret arn.
     * </p>
     * 
     * @return Source Server connector action credentials secret arn.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceServerConnectorAction)) {
            return false;
        }
        SourceServerConnectorAction other = (SourceServerConnectorAction) obj;
        return Objects.equals(connectorArn(), other.connectorArn())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceServerConnectorAction").add("ConnectorArn", connectorArn())
                .add("CredentialsSecretArn", credentialsSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceServerConnectorAction, T> g) {
        return obj -> g.apply((SourceServerConnectorAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceServerConnectorAction> {
        /**
         * <p>
         * Source Server connector action connector arn.
         * </p>
         * 
         * @param connectorArn
         *        Source Server connector action connector arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * Source Server connector action credentials secret arn.
         * </p>
         * 
         * @param credentialsSecretArn
         *        Source Server connector action credentials secret arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectorArn;

        private String credentialsSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceServerConnectorAction model) {
            connectorArn(model.connectorArn);
            credentialsSecretArn(model.credentialsSecretArn);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        @Override
        public SourceServerConnectorAction build() {
            return new SourceServerConnectorAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
