/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ListSourceResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListSourceResourcesResponse;
import software.amazon.awssdk.services.migrationhub.model.SourceResource;

public class ListSourceResourcesIterable
implements SdkIterable<ListSourceResourcesResponse> {
    private final MigrationHubClient client;
    private final ListSourceResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceResourcesIterable(MigrationHubClient client, ListSourceResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSourceResourcesResponseFetcher();
    }

    public Iterator<ListSourceResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceResource> sourceResourceList() {
        Function<ListSourceResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceResourceList() != null) {
                return response.sourceResourceList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceResourcesResponseFetcher
    implements SyncPageFetcher<ListSourceResourcesResponse> {
        private ListSourceResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceResourcesResponse nextPage(ListSourceResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListSourceResourcesIterable.this.client.listSourceResources(ListSourceResourcesIterable.this.firstRequest);
            }
            return ListSourceResourcesIterable.this.client.listSourceResources((ListSourceResourcesRequest)((Object)ListSourceResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

