/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowRequest extends MigrationHubOrchestratorRequest implements
        ToCopyableBuilder<CreateWorkflowRequest.Builder, CreateWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkflowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(CreateWorkflowRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> APPLICATION_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("applicationConfigurationId")
            .getter(getter(CreateWorkflowRequest::applicationConfigurationId))
            .setter(setter(Builder::applicationConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfigurationId").build())
            .build();

    private static final SdkField<Map<String, StepInput>> INPUT_PARAMETERS_FIELD = SdkField
            .<Map<String, StepInput>> builder(MarshallingType.MAP)
            .memberName("inputParameters")
            .getter(getter(CreateWorkflowRequest::inputParameters))
            .setter(setter(Builder::inputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<StepInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> STEP_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stepTargets")
            .getter(getter(CreateWorkflowRequest::stepTargets))
            .setter(setter(Builder::stepTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateWorkflowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TEMPLATE_ID_FIELD, APPLICATION_CONFIGURATION_ID_FIELD, INPUT_PARAMETERS_FIELD, STEP_TARGETS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String templateId;

    private final String applicationConfigurationId;

    private final Map<String, StepInput> inputParameters;

    private final List<String> stepTargets;

    private final Map<String, String> tags;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.applicationConfigurationId = builder.applicationConfigurationId;
        this.inputParameters = builder.inputParameters;
        this.stepTargets = builder.stepTargets;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the migration workflow.
     * </p>
     * 
     * @return The name of the migration workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the migration workflow.
     * </p>
     * 
     * @return The description of the migration workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The configuration ID of the application configured in Application Discovery Service.
     * </p>
     * 
     * @return The configuration ID of the application configured in Application Discovery Service.
     */
    public final String applicationConfigurationId() {
        return applicationConfigurationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputParameters() {
        return inputParameters != null && !(inputParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input parameters required to create a migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputParameters} method.
     * </p>
     * 
     * @return The input parameters required to create a migration workflow.
     */
    public final Map<String, StepInput> inputParameters() {
        return inputParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStepTargets() {
        return stepTargets != null && !(stepTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The servers on which a step will be run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepTargets} method.
     * </p>
     * 
     * @return The servers on which a step will be run.
     */
    public final List<String> stepTargets() {
        return stepTargets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add on a migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add on a migration workflow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputParameters() ? inputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStepTargets() ? stepTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(templateId(), other.templateId())
                && Objects.equals(applicationConfigurationId(), other.applicationConfigurationId())
                && hasInputParameters() == other.hasInputParameters()
                && Objects.equals(inputParameters(), other.inputParameters()) && hasStepTargets() == other.hasStepTargets()
                && Objects.equals(stepTargets(), other.stepTargets()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowRequest").add("Name", name()).add("Description", description())
                .add("TemplateId", templateId()).add("ApplicationConfigurationId", applicationConfigurationId())
                .add("InputParameters", inputParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StepTargets", hasStepTargets() ? stepTargets() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "applicationConfigurationId":
            return Optional.ofNullable(clazz.cast(applicationConfigurationId()));
        case "inputParameters":
            return Optional.ofNullable(clazz.cast(inputParameters()));
        case "stepTargets":
            return Optional.ofNullable(clazz.cast(stepTargets()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorkflowRequest> {
        /**
         * <p>
         * The name of the migration workflow.
         * </p>
         * 
         * @param name
         *        The name of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the migration workflow.
         * </p>
         * 
         * @param description
         *        The description of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param templateId
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The configuration ID of the application configured in Application Discovery Service.
         * </p>
         * 
         * @param applicationConfigurationId
         *        The configuration ID of the application configured in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationConfigurationId(String applicationConfigurationId);

        /**
         * <p>
         * The input parameters required to create a migration workflow.
         * </p>
         * 
         * @param inputParameters
         *        The input parameters required to create a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParameters(Map<String, StepInput> inputParameters);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTargets
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTargets(Collection<String> stepTargets);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTargets
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTargets(String... stepTargets);

        /**
         * <p>
         * The tags to add on a migration workflow.
         * </p>
         * 
         * @param tags
         *        The tags to add on a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String templateId;

        private String applicationConfigurationId;

        private Map<String, StepInput> inputParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> stepTargets = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            templateId(model.templateId);
            applicationConfigurationId(model.applicationConfigurationId);
            inputParameters(model.inputParameters);
            stepTargets(model.stepTargets);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getApplicationConfigurationId() {
            return applicationConfigurationId;
        }

        public final void setApplicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
        }

        @Override
        public final Builder applicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
            return this;
        }

        public final Map<String, StepInput.Builder> getInputParameters() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.inputParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputParameters(Map<String, StepInput.BuilderImpl> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copyFromBuilder(inputParameters);
        }

        @Override
        public final Builder inputParameters(Map<String, StepInput> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copy(inputParameters);
            return this;
        }

        public final Collection<String> getStepTargets() {
            if (stepTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return stepTargets;
        }

        public final void setStepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
        }

        @Override
        public final Builder stepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTargets(String... stepTargets) {
            stepTargets(Arrays.asList(stepTargets));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
