/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateStepGroupsResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<ListTemplateStepGroupsResponse.Builder, ListTemplateStepGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTemplateStepGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TemplateStepGroupSummary>> TEMPLATE_STEP_GROUP_SUMMARY_FIELD = SdkField
            .<List<TemplateStepGroupSummary>> builder(MarshallingType.LIST)
            .memberName("templateStepGroupSummary")
            .getter(getter(ListTemplateStepGroupsResponse::templateStepGroupSummary))
            .setter(setter(Builder::templateStepGroupSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateStepGroupSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateStepGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateStepGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEMPLATE_STEP_GROUP_SUMMARY_FIELD));

    private final String nextToken;

    private final List<TemplateStepGroupSummary> templateStepGroupSummary;

    private ListTemplateStepGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateStepGroupSummary = builder.templateStepGroupSummary;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateStepGroupSummary property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTemplateStepGroupSummary() {
        return templateStepGroupSummary != null && !(templateStepGroupSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary of the step group in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateStepGroupSummary} method.
     * </p>
     * 
     * @return The summary of the step group in the template.
     */
    public final List<TemplateStepGroupSummary> templateStepGroupSummary() {
        return templateStepGroupSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateStepGroupSummary() ? templateStepGroupSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateStepGroupsResponse)) {
            return false;
        }
        ListTemplateStepGroupsResponse other = (ListTemplateStepGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasTemplateStepGroupSummary() == other.hasTemplateStepGroupSummary()
                && Objects.equals(templateStepGroupSummary(), other.templateStepGroupSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplateStepGroupsResponse").add("NextToken", nextToken())
                .add("TemplateStepGroupSummary", hasTemplateStepGroupSummary() ? templateStepGroupSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "templateStepGroupSummary":
            return Optional.ofNullable(clazz.cast(templateStepGroupSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateStepGroupsResponse, T> g) {
        return obj -> g.apply((ListTemplateStepGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTemplateStepGroupsResponse> {
        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The summary of the step group in the template.
         * </p>
         * 
         * @param templateStepGroupSummary
         *        The summary of the step group in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateStepGroupSummary(Collection<TemplateStepGroupSummary> templateStepGroupSummary);

        /**
         * <p>
         * The summary of the step group in the template.
         * </p>
         * 
         * @param templateStepGroupSummary
         *        The summary of the step group in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateStepGroupSummary(TemplateStepGroupSummary... templateStepGroupSummary);

        /**
         * <p>
         * The summary of the step group in the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #templateStepGroupSummary(List<TemplateStepGroupSummary>)}.
         * 
         * @param templateStepGroupSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateStepGroupSummary(java.util.Collection<TemplateStepGroupSummary>)
         */
        Builder templateStepGroupSummary(Consumer<TemplateStepGroupSummary.Builder>... templateStepGroupSummary);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TemplateStepGroupSummary> templateStepGroupSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateStepGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            templateStepGroupSummary(model.templateStepGroupSummary);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TemplateStepGroupSummary.Builder> getTemplateStepGroupSummary() {
            List<TemplateStepGroupSummary.Builder> result = TemplateStepGroupSummaryListCopier
                    .copyToBuilder(this.templateStepGroupSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateStepGroupSummary(Collection<TemplateStepGroupSummary.BuilderImpl> templateStepGroupSummary) {
            this.templateStepGroupSummary = TemplateStepGroupSummaryListCopier.copyFromBuilder(templateStepGroupSummary);
        }

        @Override
        public final Builder templateStepGroupSummary(Collection<TemplateStepGroupSummary> templateStepGroupSummary) {
            this.templateStepGroupSummary = TemplateStepGroupSummaryListCopier.copy(templateStepGroupSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateStepGroupSummary(TemplateStepGroupSummary... templateStepGroupSummary) {
            templateStepGroupSummary(Arrays.asList(templateStepGroupSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateStepGroupSummary(Consumer<TemplateStepGroupSummary.Builder>... templateStepGroupSummary) {
            templateStepGroupSummary(Stream.of(templateStepGroupSummary)
                    .map(c -> TemplateStepGroupSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTemplateStepGroupsResponse build() {
            return new ListTemplateStepGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
