/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient;
import software.amazon.awssdk.services.migrationhuborchestrator.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary;

public class ListWorkflowsPublisher
implements SdkPublisher<ListWorkflowsResponse> {
    private final MigrationHubOrchestratorAsyncClient client;
    private final ListWorkflowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowsPublisher(MigrationHubOrchestratorAsyncClient client, ListWorkflowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowsPublisher(MigrationHubOrchestratorAsyncClient client, ListWorkflowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MigrationWorkflowSummary> migrationWorkflowSummary() {
        Function<ListWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.migrationWorkflowSummary() != null) {
                return response.migrationWorkflowSummary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowsResponse> {
        private ListWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowsResponse> nextPage(ListWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowsPublisher.this.client.listWorkflows(ListWorkflowsPublisher.this.firstRequest);
            }
            return ListWorkflowsPublisher.this.client.listWorkflows((ListWorkflowsRequest)((Object)ListWorkflowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

