/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.migrationhuborchestrator.endpoints.MigrationHubOrchestratorEndpointParams;
import software.amazon.awssdk.services.migrationhuborchestrator.endpoints.MigrationHubOrchestratorEndpointProvider;
import software.amazon.awssdk.services.migrationhuborchestrator.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.migrationhuborchestrator.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.migrationhuborchestrator.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultMigrationHubOrchestratorEndpointProvider
implements MigrationHubOrchestratorEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(MigrationHubOrchestratorEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(MigrationHubOrchestratorEndpointParams params, String region) {
        RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(MigrationHubOrchestratorEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(MigrationHubOrchestratorEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(MigrationHubOrchestratorEndpointParams params, String region) {
        RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(MigrationHubOrchestratorEndpointParams params, String region) {
        if (region != null) {
            return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(MigrationHubOrchestratorEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule9(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule14(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule24(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(MigrationHubOrchestratorEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule10(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(MigrationHubOrchestratorEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule11(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(MigrationHubOrchestratorEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://migrationhub-orchestrator-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule14(MigrationHubOrchestratorEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule15(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(MigrationHubOrchestratorEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule16(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(MigrationHubOrchestratorEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://migrationhub-orchestrator-fips." + region + "." + partitionResult.dnsSuffix())).build());
    }

    private static RuleResult endpointRule19(MigrationHubOrchestratorEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultMigrationHubOrchestratorEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(MigrationHubOrchestratorEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return DefaultMigrationHubOrchestratorEndpointProvider.endpointRule21(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(MigrationHubOrchestratorEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://migrationhub-orchestrator." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule24(MigrationHubOrchestratorEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://migrationhub-orchestrator." + region + "." + partitionResult.dnsSuffix())).build());
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

