/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringMapCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInputListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStatus;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Tool;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ToolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetTemplateResponse.getter(GetTemplateResponse::id)).setter(GetTemplateResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(GetTemplateResponse.getter(GetTemplateResponse::templateArn)).setter(GetTemplateResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTemplateResponse.getter(GetTemplateResponse::name)).setter(GetTemplateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTemplateResponse.getter(GetTemplateResponse::description)).setter(GetTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<TemplateInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(GetTemplateResponse.getter(GetTemplateResponse::inputs)).setter(GetTemplateResponse.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(GetTemplateResponse.getter(GetTemplateResponse::tools)).setter(GetTemplateResponse.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetTemplateResponse.getter(GetTemplateResponse::creationTime)).setter(GetTemplateResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(GetTemplateResponse.getter(GetTemplateResponse::owner)).setter(GetTemplateResponse.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTemplateResponse.getter(GetTemplateResponse::statusAsString)).setter(GetTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetTemplateResponse.getter(GetTemplateResponse::statusMessage)).setter(GetTemplateResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> TEMPLATE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateClass").getter(GetTemplateResponse.getter(GetTemplateResponse::templateClass)).setter(GetTemplateResponse.setter(Builder::templateClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateClass").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTemplateResponse.getter(GetTemplateResponse::tags)).setter(GetTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEMPLATE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, INPUTS_FIELD, TOOLS_FIELD, CREATION_TIME_FIELD, OWNER_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TEMPLATE_CLASS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTemplateResponse.memberNameToFieldInitializer();
    private final String id;
    private final String templateArn;
    private final String name;
    private final String description;
    private final List<TemplateInput> inputs;
    private final List<Tool> tools;
    private final Instant creationTime;
    private final String owner;
    private final String status;
    private final String statusMessage;
    private final String templateClass;
    private final Map<String, String> tags;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.templateArn = builder.templateArn;
        this.name = builder.name;
        this.description = builder.description;
        this.inputs = builder.inputs;
        this.tools = builder.tools;
        this.creationTime = builder.creationTime;
        this.owner = builder.owner;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.templateClass = builder.templateClass;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<TemplateInput> inputs() {
        return this.inputs;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<Tool> tools() {
        return this.tools;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String owner() {
        return this.owner;
    }

    public final TemplateStatus status() {
        return TemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String templateClass() {
        return this.templateClass;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.templateClass(), other.templateClass()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateResponse").add("Id", (Object)this.id()).add("TemplateArn", (Object)this.templateArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Tools", this.hasTools() ? this.tools() : null).add("CreationTime", (Object)this.creationTime()).add("Owner", (Object)this.owner()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("TemplateClass", (Object)this.templateClass()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "templateClass": {
                return Optional.ofNullable(clazz.cast(this.templateClass()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("templateClass", TEMPLATE_CLASS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String templateArn;
        private String name;
        private String description;
        private List<TemplateInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private String owner;
        private String status;
        private String statusMessage;
        private String templateClass;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            this.id(model.id);
            this.templateArn(model.templateArn);
            this.name(model.name);
            this.description(model.description);
            this.inputs(model.inputs);
            this.tools(model.tools);
            this.creationTime(model.creationTime);
            this.owner(model.owner);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.templateClass(model.templateClass);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TemplateInput.Builder> getInputs() {
            List<TemplateInput.Builder> result = TemplateInputListCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<TemplateInput.BuilderImpl> inputs) {
            this.inputs = TemplateInputListCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<TemplateInput> inputs) {
            this.inputs = TemplateInputListCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(TemplateInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<TemplateInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (TemplateInput)((TemplateInput.Builder)TemplateInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder> ... tools) {
            this.tools(Stream.of(tools).map(c -> (Tool)((Tool.Builder)Tool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getTemplateClass() {
            return this.templateClass;
        }

        public final void setTemplateClass(String templateClass) {
            this.templateClass = templateClass;
        }

        @Override
        public final Builder templateClass(String templateClass) {
            this.templateClass = templateClass;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder id(String var1);

        public Builder templateArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder inputs(Collection<TemplateInput> var1);

        public Builder inputs(TemplateInput ... var1);

        public Builder inputs(Consumer<TemplateInput.Builder> ... var1);

        public Builder tools(Collection<Tool> var1);

        public Builder tools(Tool ... var1);

        public Builder tools(Consumer<Tool.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder owner(String var1);

        public Builder status(String var1);

        public Builder status(TemplateStatus var1);

        public Builder statusMessage(String var1);

        public Builder templateClass(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

