/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowStatusEnum;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInputParametersCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringMapCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Tool;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ToolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, GetWorkflowResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetWorkflowResponse.getter(GetWorkflowResponse::id)).setter(GetWorkflowResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetWorkflowResponse.getter(GetWorkflowResponse::arn)).setter(GetWorkflowResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetWorkflowResponse.getter(GetWorkflowResponse::name)).setter(GetWorkflowResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetWorkflowResponse.getter(GetWorkflowResponse::description)).setter(GetWorkflowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(GetWorkflowResponse.getter(GetWorkflowResponse::templateId)).setter(GetWorkflowResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<String> ADS_APPLICATION_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adsApplicationConfigurationId").getter(GetWorkflowResponse.getter(GetWorkflowResponse::adsApplicationConfigurationId)).setter(GetWorkflowResponse.setter(Builder::adsApplicationConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationConfigurationId").build()}).build();
    private static final SdkField<String> ADS_APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adsApplicationName").getter(GetWorkflowResponse.getter(GetWorkflowResponse::adsApplicationName)).setter(GetWorkflowResponse.setter(Builder::adsApplicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowResponse.getter(GetWorkflowResponse::statusAsString)).setter(GetWorkflowResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetWorkflowResponse.getter(GetWorkflowResponse::statusMessage)).setter(GetWorkflowResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::creationTime)).setter(GetWorkflowResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::lastStartTime)).setter(GetWorkflowResponse.setter(Builder::lastStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()}).build();
    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStopTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::lastStopTime)).setter(GetWorkflowResponse.setter(Builder::lastStopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::lastModifiedTime)).setter(GetWorkflowResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::endTime)).setter(GetWorkflowResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(GetWorkflowResponse.getter(GetWorkflowResponse::tools)).setter(GetWorkflowResponse.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalSteps").getter(GetWorkflowResponse.getter(GetWorkflowResponse::totalSteps)).setter(GetWorkflowResponse.setter(Builder::totalSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSteps").build()}).build();
    private static final SdkField<Integer> COMPLETED_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("completedSteps").getter(GetWorkflowResponse.getter(GetWorkflowResponse::completedSteps)).setter(GetWorkflowResponse.setter(Builder::completedSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedSteps").build()}).build();
    private static final SdkField<Map<String, StepInput>> WORKFLOW_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("workflowInputs").getter(GetWorkflowResponse.getter(GetWorkflowResponse::workflowInputs)).setter(GetWorkflowResponse.setter(Builder::workflowInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowInputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetWorkflowResponse.getter(GetWorkflowResponse::tags)).setter(GetWorkflowResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBucket").getter(GetWorkflowResponse.getter(GetWorkflowResponse::workflowBucket)).setter(GetWorkflowResponse.setter(Builder::workflowBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, ADS_APPLICATION_CONFIGURATION_ID_FIELD, ADS_APPLICATION_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_START_TIME_FIELD, LAST_STOP_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, TOOLS_FIELD, TOTAL_STEPS_FIELD, COMPLETED_STEPS_FIELD, WORKFLOW_INPUTS_FIELD, TAGS_FIELD, WORKFLOW_BUCKET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final String templateId;
    private final String adsApplicationConfigurationId;
    private final String adsApplicationName;
    private final String status;
    private final String statusMessage;
    private final Instant creationTime;
    private final Instant lastStartTime;
    private final Instant lastStopTime;
    private final Instant lastModifiedTime;
    private final Instant endTime;
    private final List<Tool> tools;
    private final Integer totalSteps;
    private final Integer completedSteps;
    private final Map<String, StepInput> workflowInputs;
    private final Map<String, String> tags;
    private final String workflowBucket;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.adsApplicationConfigurationId = builder.adsApplicationConfigurationId;
        this.adsApplicationName = builder.adsApplicationName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.tools = builder.tools;
        this.totalSteps = builder.totalSteps;
        this.completedSteps = builder.completedSteps;
        this.workflowInputs = builder.workflowInputs;
        this.tags = builder.tags;
        this.workflowBucket = builder.workflowBucket;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String adsApplicationConfigurationId() {
        return this.adsApplicationConfigurationId;
    }

    public final String adsApplicationName() {
        return this.adsApplicationName;
    }

    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastStartTime() {
        return this.lastStartTime;
    }

    public final Instant lastStopTime() {
        return this.lastStopTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<Tool> tools() {
        return this.tools;
    }

    public final Integer totalSteps() {
        return this.totalSteps;
    }

    public final Integer completedSteps() {
        return this.completedSteps;
    }

    public final boolean hasWorkflowInputs() {
        return this.workflowInputs != null && !(this.workflowInputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, StepInput> workflowInputs() {
        return this.workflowInputs;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workflowBucket() {
        return this.workflowBucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsApplicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflowInputs() ? this.workflowInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBucket());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.adsApplicationConfigurationId(), other.adsApplicationConfigurationId()) && Objects.equals(this.adsApplicationName(), other.adsApplicationName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.lastStopTime(), other.lastStopTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && Objects.equals(this.totalSteps(), other.totalSteps()) && Objects.equals(this.completedSteps(), other.completedSteps()) && this.hasWorkflowInputs() == other.hasWorkflowInputs() && Objects.equals(this.workflowInputs(), other.workflowInputs()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workflowBucket(), other.workflowBucket());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TemplateId", (Object)this.templateId()).add("AdsApplicationConfigurationId", (Object)this.adsApplicationConfigurationId()).add("AdsApplicationName", (Object)this.adsApplicationName()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTime", (Object)this.creationTime()).add("LastStartTime", (Object)this.lastStartTime()).add("LastStopTime", (Object)this.lastStopTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("EndTime", (Object)this.endTime()).add("Tools", this.hasTools() ? this.tools() : null).add("TotalSteps", (Object)this.totalSteps()).add("CompletedSteps", (Object)this.completedSteps()).add("WorkflowInputs", (Object)(this.workflowInputs() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).add("WorkflowBucket", (Object)this.workflowBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "adsApplicationConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.adsApplicationConfigurationId()));
            }
            case "adsApplicationName": {
                return Optional.ofNullable(clazz.cast(this.adsApplicationName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastStartTime()));
            }
            case "lastStopTime": {
                return Optional.ofNullable(clazz.cast(this.lastStopTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "totalSteps": {
                return Optional.ofNullable(clazz.cast(this.totalSteps()));
            }
            case "completedSteps": {
                return Optional.ofNullable(clazz.cast(this.completedSteps()));
            }
            case "workflowInputs": {
                return Optional.ofNullable(clazz.cast(this.workflowInputs()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workflowBucket": {
                return Optional.ofNullable(clazz.cast(this.workflowBucket()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("adsApplicationConfigurationId", ADS_APPLICATION_CONFIGURATION_ID_FIELD);
        map.put("adsApplicationName", ADS_APPLICATION_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastStartTime", LAST_START_TIME_FIELD);
        map.put("lastStopTime", LAST_STOP_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("totalSteps", TOTAL_STEPS_FIELD);
        map.put("completedSteps", COMPLETED_STEPS_FIELD);
        map.put("workflowInputs", WORKFLOW_INPUTS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workflowBucket", WORKFLOW_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private String templateId;
        private String adsApplicationConfigurationId;
        private String adsApplicationName;
        private String status;
        private String statusMessage;
        private Instant creationTime;
        private Instant lastStartTime;
        private Instant lastStopTime;
        private Instant lastModifiedTime;
        private Instant endTime;
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();
        private Integer totalSteps;
        private Integer completedSteps;
        private Map<String, StepInput> workflowInputs = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workflowBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.templateId(model.templateId);
            this.adsApplicationConfigurationId(model.adsApplicationConfigurationId);
            this.adsApplicationName(model.adsApplicationName);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTime(model.creationTime);
            this.lastStartTime(model.lastStartTime);
            this.lastStopTime(model.lastStopTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.endTime(model.endTime);
            this.tools(model.tools);
            this.totalSteps(model.totalSteps);
            this.completedSteps(model.completedSteps);
            this.workflowInputs(model.workflowInputs);
            this.tags(model.tags);
            this.workflowBucket(model.workflowBucket);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAdsApplicationConfigurationId() {
            return this.adsApplicationConfigurationId;
        }

        public final void setAdsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
        }

        @Override
        public final Builder adsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
            return this;
        }

        public final String getAdsApplicationName() {
            return this.adsApplicationName;
        }

        public final void setAdsApplicationName(String adsApplicationName) {
            this.adsApplicationName = adsApplicationName;
        }

        @Override
        public final Builder adsApplicationName(String adsApplicationName) {
            this.adsApplicationName = adsApplicationName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final Instant getLastStopTime() {
            return this.lastStopTime;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder> ... tools) {
            this.tools(Stream.of(tools).map(c -> (Tool)((Tool.Builder)Tool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalSteps() {
            return this.totalSteps;
        }

        public final void setTotalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
        }

        @Override
        public final Builder totalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        public final Integer getCompletedSteps() {
            return this.completedSteps;
        }

        public final void setCompletedSteps(Integer completedSteps) {
            this.completedSteps = completedSteps;
        }

        @Override
        public final Builder completedSteps(Integer completedSteps) {
            this.completedSteps = completedSteps;
            return this;
        }

        public final Map<String, StepInput.Builder> getWorkflowInputs() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.workflowInputs);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkflowInputs(Map<String, StepInput.BuilderImpl> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copyFromBuilder(workflowInputs);
        }

        @Override
        public final Builder workflowInputs(Map<String, StepInput> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copy(workflowInputs);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        public final String getWorkflowBucket() {
            return this.workflowBucket;
        }

        public final void setWorkflowBucket(String workflowBucket) {
            this.workflowBucket = workflowBucket;
        }

        @Override
        public final Builder workflowBucket(String workflowBucket) {
            this.workflowBucket = workflowBucket;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder templateId(String var1);

        public Builder adsApplicationConfigurationId(String var1);

        public Builder adsApplicationName(String var1);

        public Builder status(String var1);

        public Builder status(MigrationWorkflowStatusEnum var1);

        public Builder statusMessage(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastStartTime(Instant var1);

        public Builder lastStopTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder tools(Collection<Tool> var1);

        public Builder tools(Tool ... var1);

        public Builder tools(Consumer<Tool.Builder> ... var1);

        public Builder totalSteps(Integer var1);

        public Builder completedSteps(Integer var1);

        public Builder workflowInputs(Map<String, StepInput> var1);

        public Builder tags(Map<String, String> var1);

        public Builder workflowBucket(String var1);
    }
}

