/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryWorkflowStepResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, RetryWorkflowStepResponse> {
    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepGroupId").getter(RetryWorkflowStepResponse.getter(RetryWorkflowStepResponse::stepGroupId)).setter(RetryWorkflowStepResponse.setter(Builder::stepGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(RetryWorkflowStepResponse.getter(RetryWorkflowStepResponse::workflowId)).setter(RetryWorkflowStepResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(RetryWorkflowStepResponse.getter(RetryWorkflowStepResponse::id)).setter(RetryWorkflowStepResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RetryWorkflowStepResponse.getter(RetryWorkflowStepResponse::statusAsString)).setter(RetryWorkflowStepResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_GROUP_ID_FIELD, WORKFLOW_ID_FIELD, ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetryWorkflowStepResponse.memberNameToFieldInitializer();
    private final String stepGroupId;
    private final String workflowId;
    private final String id;
    private final String status;

    private RetryWorkflowStepResponse(BuilderImpl builder) {
        super(builder);
        this.stepGroupId = builder.stepGroupId;
        this.workflowId = builder.workflowId;
        this.id = builder.id;
        this.status = builder.status;
    }

    public final String stepGroupId() {
        return this.stepGroupId;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String id() {
        return this.id;
    }

    public final StepStatus status() {
        return StepStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryWorkflowStepResponse)) {
            return false;
        }
        RetryWorkflowStepResponse other = (RetryWorkflowStepResponse)((Object)obj);
        return Objects.equals(this.stepGroupId(), other.stepGroupId()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetryWorkflowStepResponse").add("StepGroupId", (Object)this.stepGroupId()).add("WorkflowId", (Object)this.workflowId()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepGroupId": {
                return Optional.ofNullable(clazz.cast(this.stepGroupId()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("stepGroupId", STEP_GROUP_ID_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetryWorkflowStepResponse, T> g) {
        return obj -> g.apply((RetryWorkflowStepResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String stepGroupId;
        private String workflowId;
        private String id;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryWorkflowStepResponse model) {
            super(model);
            this.stepGroupId(model.stepGroupId);
            this.workflowId(model.workflowId);
            this.id(model.id);
            this.status(model.status);
        }

        public final String getStepGroupId() {
            return this.stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RetryWorkflowStepResponse build() {
            return new RetryWorkflowStepResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetryWorkflowStepResponse> {
        public Builder stepGroupId(String var1);

        public Builder workflowId(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(StepStatus var1);
    }
}

