/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.DefaultRouteInput;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesRequest;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouteRequest
extends MigrationHubRefactorSpacesRequest
implements ToCopyableBuilder<Builder, CreateRouteRequest> {
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIdentifier").getter(CreateRouteRequest.getter(CreateRouteRequest::applicationIdentifier)).setter(CreateRouteRequest.setter(Builder::applicationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationIdentifier").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRouteRequest.getter(CreateRouteRequest::clientToken)).setter(CreateRouteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DefaultRouteInput> DEFAULT_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultRoute").getter(CreateRouteRequest.getter(CreateRouteRequest::defaultRoute)).setter(CreateRouteRequest.setter(Builder::defaultRoute)).constructor(DefaultRouteInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRoute").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentIdentifier").getter(CreateRouteRequest.getter(CreateRouteRequest::environmentIdentifier)).setter(CreateRouteRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build()}).build();
    private static final SdkField<String> ROUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteType").getter(CreateRouteRequest.getter(CreateRouteRequest::routeTypeAsString)).setter(CreateRouteRequest.setter(Builder::routeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteType").build()}).build();
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceIdentifier").getter(CreateRouteRequest.getter(CreateRouteRequest::serviceIdentifier)).setter(CreateRouteRequest.setter(Builder::serviceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRouteRequest.getter(CreateRouteRequest::tags)).setter(CreateRouteRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<UriPathRouteInput> URI_PATH_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UriPathRoute").getter(CreateRouteRequest.getter(CreateRouteRequest::uriPathRoute)).setter(CreateRouteRequest.setter(Builder::uriPathRoute)).constructor(UriPathRouteInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPathRoute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDENTIFIER_FIELD, CLIENT_TOKEN_FIELD, DEFAULT_ROUTE_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, ROUTE_TYPE_FIELD, SERVICE_IDENTIFIER_FIELD, TAGS_FIELD, URI_PATH_ROUTE_FIELD));
    private final String applicationIdentifier;
    private final String clientToken;
    private final DefaultRouteInput defaultRoute;
    private final String environmentIdentifier;
    private final String routeType;
    private final String serviceIdentifier;
    private final Map<String, String> tags;
    private final UriPathRouteInput uriPathRoute;

    private CreateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIdentifier = builder.applicationIdentifier;
        this.clientToken = builder.clientToken;
        this.defaultRoute = builder.defaultRoute;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.routeType = builder.routeType;
        this.serviceIdentifier = builder.serviceIdentifier;
        this.tags = builder.tags;
        this.uriPathRoute = builder.uriPathRoute;
    }

    public final String applicationIdentifier() {
        return this.applicationIdentifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DefaultRouteInput defaultRoute() {
        return this.defaultRoute;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final RouteType routeType() {
        return RouteType.fromValue(this.routeType);
    }

    public final String routeTypeAsString() {
        return this.routeType;
    }

    public final String serviceIdentifier() {
        return this.serviceIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final UriPathRouteInput uriPathRoute() {
        return this.uriPathRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uriPathRoute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteRequest)) {
            return false;
        }
        CreateRouteRequest other = (CreateRouteRequest)((Object)obj);
        return Objects.equals(this.applicationIdentifier(), other.applicationIdentifier()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.defaultRoute(), other.defaultRoute()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.routeTypeAsString(), other.routeTypeAsString()) && Objects.equals(this.serviceIdentifier(), other.serviceIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.uriPathRoute(), other.uriPathRoute());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouteRequest").add("ApplicationIdentifier", (Object)this.applicationIdentifier()).add("ClientToken", (Object)this.clientToken()).add("DefaultRoute", (Object)this.defaultRoute()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("RouteType", (Object)this.routeTypeAsString()).add("ServiceIdentifier", (Object)this.serviceIdentifier()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("UriPathRoute", (Object)this.uriPathRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.applicationIdentifier()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DefaultRoute": {
                return Optional.ofNullable(clazz.cast(this.defaultRoute()));
            }
            case "EnvironmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "RouteType": {
                return Optional.ofNullable(clazz.cast(this.routeTypeAsString()));
            }
            case "ServiceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UriPathRoute": {
                return Optional.ofNullable(clazz.cast(this.uriPathRoute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteRequest, T> g) {
        return obj -> g.apply((CreateRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesRequest.BuilderImpl
    implements Builder {
        private String applicationIdentifier;
        private String clientToken;
        private DefaultRouteInput defaultRoute;
        private String environmentIdentifier;
        private String routeType;
        private String serviceIdentifier;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private UriPathRouteInput uriPathRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteRequest model) {
            super(model);
            this.applicationIdentifier(model.applicationIdentifier);
            this.clientToken(model.clientToken);
            this.defaultRoute(model.defaultRoute);
            this.environmentIdentifier(model.environmentIdentifier);
            this.routeType(model.routeType);
            this.serviceIdentifier(model.serviceIdentifier);
            this.tags(model.tags);
            this.uriPathRoute(model.uriPathRoute);
        }

        public final String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DefaultRouteInput.Builder getDefaultRoute() {
            return this.defaultRoute != null ? this.defaultRoute.toBuilder() : null;
        }

        public final void setDefaultRoute(DefaultRouteInput.BuilderImpl defaultRoute) {
            this.defaultRoute = defaultRoute != null ? defaultRoute.build() : null;
        }

        @Override
        public final Builder defaultRoute(DefaultRouteInput defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getRouteType() {
            return this.routeType;
        }

        public final void setRouteType(String routeType) {
            this.routeType = routeType;
        }

        @Override
        public final Builder routeType(String routeType) {
            this.routeType = routeType;
            return this;
        }

        @Override
        public final Builder routeType(RouteType routeType) {
            this.routeType(routeType == null ? null : routeType.toString());
            return this;
        }

        public final String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UriPathRouteInput.Builder getUriPathRoute() {
            return this.uriPathRoute != null ? this.uriPathRoute.toBuilder() : null;
        }

        public final void setUriPathRoute(UriPathRouteInput.BuilderImpl uriPathRoute) {
            this.uriPathRoute = uriPathRoute != null ? uriPathRoute.build() : null;
        }

        @Override
        public final Builder uriPathRoute(UriPathRouteInput uriPathRoute) {
            this.uriPathRoute = uriPathRoute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteRequest build() {
            return new CreateRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouteRequest> {
        public Builder applicationIdentifier(String var1);

        public Builder clientToken(String var1);

        public Builder defaultRoute(DefaultRouteInput var1);

        default public Builder defaultRoute(Consumer<DefaultRouteInput.Builder> defaultRoute) {
            return this.defaultRoute((DefaultRouteInput)((DefaultRouteInput.Builder)DefaultRouteInput.builder().applyMutation(defaultRoute)).build());
        }

        public Builder environmentIdentifier(String var1);

        public Builder routeType(String var1);

        public Builder routeType(RouteType var1);

        public Builder serviceIdentifier(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder uriPathRoute(UriPathRouteInput var1);

        default public Builder uriPathRoute(Consumer<UriPathRouteInput.Builder> uriPathRoute) {
            return this.uriPathRoute((UriPathRouteInput)((UriPathRouteInput.Builder)UriPathRouteInput.builder().applyMutation(uriPathRoute)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

