/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummariesCopier;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentSummary;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentsResponse
extends MigrationHubRefactorSpacesResponse
implements ToCopyableBuilder<Builder, ListEnvironmentsResponse> {
    private static final SdkField<List<EnvironmentSummary>> ENVIRONMENT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentSummaryList").getter(ListEnvironmentsResponse.getter(ListEnvironmentsResponse::environmentSummaryList)).setter(ListEnvironmentsResponse.setter(Builder::environmentSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEnvironmentsResponse.getter(ListEnvironmentsResponse::nextToken)).setter(ListEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentsResponse.memberNameToFieldInitializer();
    private final List<EnvironmentSummary> environmentSummaryList;
    private final String nextToken;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environmentSummaryList = builder.environmentSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEnvironmentSummaryList() {
        return this.environmentSummaryList != null && !(this.environmentSummaryList instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentSummary> environmentSummaryList() {
        return this.environmentSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentSummaryList() ? this.environmentSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse)((Object)obj);
        return this.hasEnvironmentSummaryList() == other.hasEnvironmentSummaryList() && Objects.equals(this.environmentSummaryList(), other.environmentSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnvironmentsResponse").add("EnvironmentSummaryList", this.hasEnvironmentSummaryList() ? this.environmentSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentSummaryList": {
                return Optional.ofNullable(clazz.cast(this.environmentSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnvironmentSummaryList", ENVIRONMENT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentSummary> environmentSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            this.environmentSummaryList(model.environmentSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<EnvironmentSummary.Builder> getEnvironmentSummaryList() {
            List<EnvironmentSummary.Builder> result = EnvironmentSummariesCopier.copyToBuilder(this.environmentSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentSummaryList(Collection<EnvironmentSummary.BuilderImpl> environmentSummaryList) {
            this.environmentSummaryList = EnvironmentSummariesCopier.copyFromBuilder(environmentSummaryList);
        }

        @Override
        public final Builder environmentSummaryList(Collection<EnvironmentSummary> environmentSummaryList) {
            this.environmentSummaryList = EnvironmentSummariesCopier.copy(environmentSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentSummaryList(EnvironmentSummary ... environmentSummaryList) {
            this.environmentSummaryList(Arrays.asList(environmentSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentSummaryList(Consumer<EnvironmentSummary.Builder> ... environmentSummaryList) {
            this.environmentSummaryList(Stream.of(environmentSummaryList).map(c -> (EnvironmentSummary)((EnvironmentSummary.Builder)EnvironmentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubRefactorSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentsResponse> {
        public Builder environmentSummaryList(Collection<EnvironmentSummary> var1);

        public Builder environmentSummaryList(EnvironmentSummary ... var1);

        public Builder environmentSummaryList(Consumer<EnvironmentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

