/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mturk.DefaultMTurkBaseClientBuilder;
import software.amazon.awssdk.services.mturk.DefaultMTurkClient;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.MTurkClientBuilder;
import software.amazon.awssdk.services.mturk.MTurkServiceClientConfiguration;
import software.amazon.awssdk.services.mturk.endpoints.MTurkEndpointProvider;

@SdkInternalApi
final class DefaultMTurkClientBuilder
extends DefaultMTurkBaseClientBuilder<MTurkClientBuilder, MTurkClient>
implements MTurkClientBuilder {
    DefaultMTurkClientBuilder() {
    }

    @Override
    public DefaultMTurkClientBuilder endpointProvider(MTurkEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MTurkClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMTurkClientBuilder.validateClientOptions(clientConfiguration);
        MTurkServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMTurkClient client = new DefaultMTurkClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MTurkServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MTurkServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

