/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteGremlinQueryRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, ExecuteGremlinQueryRequest> {
    private static final SdkField<String> GREMLIN_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gremlinQuery").getter(ExecuteGremlinQueryRequest.getter(ExecuteGremlinQueryRequest::gremlinQuery)).setter(ExecuteGremlinQueryRequest.setter(Builder::gremlinQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()}).build();
    private static final SdkField<String> SERIALIZER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serializer").getter(ExecuteGremlinQueryRequest.getter(ExecuteGremlinQueryRequest::serializer)).setter(ExecuteGremlinQueryRequest.setter(Builder::serializer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("accept").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREMLIN_QUERY_FIELD, SERIALIZER_FIELD));
    private final String gremlinQuery;
    private final String serializer;

    private ExecuteGremlinQueryRequest(BuilderImpl builder) {
        super(builder);
        this.gremlinQuery = builder.gremlinQuery;
        this.serializer = builder.serializer;
    }

    public final String gremlinQuery() {
        return this.gremlinQuery;
    }

    public final String serializer() {
        return this.serializer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gremlinQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.serializer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteGremlinQueryRequest)) {
            return false;
        }
        ExecuteGremlinQueryRequest other = (ExecuteGremlinQueryRequest)((Object)obj);
        return Objects.equals(this.gremlinQuery(), other.gremlinQuery()) && Objects.equals(this.serializer(), other.serializer());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteGremlinQueryRequest").add("GremlinQuery", (Object)this.gremlinQuery()).add("Serializer", (Object)this.serializer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gremlinQuery": {
                return Optional.ofNullable(clazz.cast(this.gremlinQuery()));
            }
            case "serializer": {
                return Optional.ofNullable(clazz.cast(this.serializer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteGremlinQueryRequest, T> g) {
        return obj -> g.apply((ExecuteGremlinQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String gremlinQuery;
        private String serializer;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteGremlinQueryRequest model) {
            super(model);
            this.gremlinQuery(model.gremlinQuery);
            this.serializer(model.serializer);
        }

        public final String getGremlinQuery() {
            return this.gremlinQuery;
        }

        public final void setGremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
        }

        @Override
        public final Builder gremlinQuery(String gremlinQuery) {
            this.gremlinQuery = gremlinQuery;
            return this;
        }

        public final String getSerializer() {
            return this.serializer;
        }

        public final void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        @Override
        public final Builder serializer(String serializer) {
            this.serializer = serializer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteGremlinQueryRequest build() {
            return new ExecuteGremlinQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteGremlinQueryRequest> {
        public Builder gremlinQuery(String var1);

        public Builder serializer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

