/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.MlResourceDefinition;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlDataProcessingJobResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetMlDataProcessingJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetMlDataProcessingJobResponse.getter(GetMlDataProcessingJobResponse::status)).setter(GetMlDataProcessingJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetMlDataProcessingJobResponse.getter(GetMlDataProcessingJobResponse::id)).setter(GetMlDataProcessingJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MlResourceDefinition> PROCESSING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("processingJob").getter(GetMlDataProcessingJobResponse.getter(GetMlDataProcessingJobResponse::processingJob)).setter(GetMlDataProcessingJobResponse.setter(Builder::processingJob)).constructor(MlResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingJob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD, PROCESSING_JOB_FIELD));
    private final String status;
    private final String id;
    private final MlResourceDefinition processingJob;

    private GetMlDataProcessingJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.processingJob = builder.processingJob;
    }

    public final String status() {
        return this.status;
    }

    public final String id() {
        return this.id;
    }

    public final MlResourceDefinition processingJob() {
        return this.processingJob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJob());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlDataProcessingJobResponse)) {
            return false;
        }
        GetMlDataProcessingJobResponse other = (GetMlDataProcessingJobResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.processingJob(), other.processingJob());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlDataProcessingJobResponse").add("Status", (Object)this.status()).add("Id", (Object)this.id()).add("ProcessingJob", (Object)this.processingJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "processingJob": {
                return Optional.ofNullable(clazz.cast(this.processingJob()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlDataProcessingJobResponse, T> g) {
        return obj -> g.apply((GetMlDataProcessingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private String status;
        private String id;
        private MlResourceDefinition processingJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlDataProcessingJobResponse model) {
            super(model);
            this.status(model.status);
            this.id(model.id);
            this.processingJob(model.processingJob);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getProcessingJob() {
            return this.processingJob != null ? this.processingJob.toBuilder() : null;
        }

        public final void setProcessingJob(MlResourceDefinition.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        @Override
        public final Builder processingJob(MlResourceDefinition processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        @Override
        public GetMlDataProcessingJobResponse build() {
            return new GetMlDataProcessingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlDataProcessingJobResponse> {
        public Builder status(String var1);

        public Builder id(String var1);

        public Builder processingJob(MlResourceDefinition var1);

        default public Builder processingJob(Consumer<MlResourceDefinition.Builder> processingJob) {
            return this.processingJob((MlResourceDefinition)((MlResourceDefinition.Builder)MlResourceDefinition.builder().applyMutation(processingJob)).build());
        }
    }
}

