/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.GraphSnapshotSummary;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse;

public class ListGraphSnapshotsPublisher
implements SdkPublisher<ListGraphSnapshotsResponse> {
    private final NeptuneGraphAsyncClient client;
    private final ListGraphSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGraphSnapshotsPublisher(NeptuneGraphAsyncClient client, ListGraphSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGraphSnapshotsPublisher(NeptuneGraphAsyncClient client, ListGraphSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGraphSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGraphSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GraphSnapshotSummary> graphSnapshots() {
        Function<ListGraphSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.graphSnapshots() != null) {
                return response.graphSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGraphSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGraphSnapshotsResponseFetcher
    implements AsyncPageFetcher<ListGraphSnapshotsResponse> {
        private ListGraphSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListGraphSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGraphSnapshotsResponse> nextPage(ListGraphSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListGraphSnapshotsPublisher.this.client.listGraphSnapshots(ListGraphSnapshotsPublisher.this.firstRequest);
            }
            return ListGraphSnapshotsPublisher.this.client.listGraphSnapshots((ListGraphSnapshotsRequest)((Object)ListGraphSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

