/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.waiters.DefaultNeptuneGraphAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface NeptuneGraphAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphAvailable(GetGraphRequest getGraphRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphAvailable(Consumer<GetGraphRequest.Builder> getGraphRequest) {
        return this.waitUntilGraphAvailable((GetGraphRequest)((Object)((GetGraphRequest.Builder)GetGraphRequest.builder().applyMutation(getGraphRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphAvailable(GetGraphRequest getGraphRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphAvailable(Consumer<GetGraphRequest.Builder> getGraphRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilGraphAvailable((GetGraphRequest)((Object)((GetGraphRequest.Builder)GetGraphRequest.builder().applyMutation(getGraphRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphDeleted(GetGraphRequest getGraphRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphDeleted(Consumer<GetGraphRequest.Builder> getGraphRequest) {
        return this.waitUntilGraphDeleted((GetGraphRequest)((Object)((GetGraphRequest.Builder)GetGraphRequest.builder().applyMutation(getGraphRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphDeleted(GetGraphRequest getGraphRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphResponse>> waitUntilGraphDeleted(Consumer<GetGraphRequest.Builder> getGraphRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilGraphDeleted((GetGraphRequest)((Object)((GetGraphRequest.Builder)GetGraphRequest.builder().applyMutation(getGraphRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotAvailable(Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest) {
        return this.waitUntilGraphSnapshotAvailable((GetGraphSnapshotRequest)((Object)((GetGraphSnapshotRequest.Builder)GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotAvailable(Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilGraphSnapshotAvailable((GetGraphSnapshotRequest)((Object)((GetGraphSnapshotRequest.Builder)GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotDeleted(Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest) {
        return this.waitUntilGraphSnapshotDeleted((GetGraphSnapshotRequest)((Object)((GetGraphSnapshotRequest.Builder)GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetGraphSnapshotResponse>> waitUntilGraphSnapshotDeleted(Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilGraphSnapshotDeleted((GetGraphSnapshotRequest)((Object)((GetGraphSnapshotRequest.Builder)GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskCancelled(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest) {
        return this.waitUntilImportTaskCancelled((GetImportTaskRequest)((Object)((GetImportTaskRequest.Builder)GetImportTaskRequest.builder().applyMutation(getImportTaskRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskCancelled(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilImportTaskCancelled((GetImportTaskRequest)((Object)((GetImportTaskRequest.Builder)GetImportTaskRequest.builder().applyMutation(getImportTaskRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskSuccessful(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest) {
        return this.waitUntilImportTaskSuccessful((GetImportTaskRequest)((Object)((GetImportTaskRequest.Builder)GetImportTaskRequest.builder().applyMutation(getImportTaskRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetImportTaskResponse>> waitUntilImportTaskSuccessful(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilImportTaskSuccessful((GetImportTaskRequest)((Object)((GetImportTaskRequest.Builder)GetImportTaskRequest.builder().applyMutation(getImportTaskRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointAvailable(Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) {
        return this.waitUntilPrivateGraphEndpointAvailable((GetPrivateGraphEndpointRequest)((Object)((GetPrivateGraphEndpointRequest.Builder)GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointAvailable(Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilPrivateGraphEndpointAvailable((GetPrivateGraphEndpointRequest)((Object)((GetPrivateGraphEndpointRequest.Builder)GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointDeleted(Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) {
        return this.waitUntilPrivateGraphEndpointDeleted((GetPrivateGraphEndpointRequest)((Object)((GetPrivateGraphEndpointRequest.Builder)GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetPrivateGraphEndpointResponse>> waitUntilPrivateGraphEndpointDeleted(Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilPrivateGraphEndpointDeleted((GetPrivateGraphEndpointRequest)((Object)((GetPrivateGraphEndpointRequest.Builder)GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultNeptuneGraphAsyncWaiter.builder();
    }

    public static NeptuneGraphAsyncWaiter create() {
        return DefaultNeptuneGraphAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(NeptuneGraphAsyncClient var1);

        public NeptuneGraphAsyncWaiter build();
    }
}

