/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsPublisher;
import software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourcePublisher;

/**
 * Service client for accessing Network Firewall asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This is the API Reference for Network Firewall. This guide is for developers who need detailed information about the
 * Network Firewall API actions, data types, and errors.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The REST API requires you to handle connection details, such as calculating signatures, handling request retries, and
 * error handling. For general information about using the Amazon Web Services REST APIs, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/aws-apis.html">Amazon Web Services APIs</a>.
 * </p>
 * <p>
 * To access Network Firewall using the REST API endpoint:
 * <code>https://network-firewall.&lt;region&gt;.amazonaws.com </code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming
 * language or platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon
 * Web Services SDKs</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of Network Firewall features, including and step-by-step instructions on how to use them through the
 * Network Firewall console, see the <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/">Network Firewall Developer Guide</a>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Network Firewall is a stateful, managed, network firewall and intrusion detection and prevention service for Amazon
 * Virtual Private Cloud (Amazon VPC). With Network Firewall, you can filter traffic at the perimeter of your VPC. This
 * includes filtering traffic going to and coming from an internet gateway, NAT gateway, or over VPN or Direct Connect.
 * Network Firewall uses rules that are compatible with Suricata, a free, open source network analysis and threat
 * detection engine. Network Firewall supports Suricata version 6.0.9. For information about Suricata, see the <a
 * href="https://suricata.io/">Suricata website</a>.
 * </p>
 * <p>
 * You can use Network Firewall to monitor and protect your VPC traffic in a number of ways. The following are just a
 * few examples:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Allow domains or IP addresses for known Amazon Web Services service endpoints, such as Amazon S3, and block all other
 * forms of traffic.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use custom lists of known bad domains to limit the types of domain names that your applications can access.
 * </p>
 * </li>
 * <li>
 * <p>
 * Perform deep packet inspection on traffic entering or leaving your VPC.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use stateful protocol detection to filter protocols like HTTPS, regardless of the port used.
 * </p>
 * </li>
 * </ul>
 * <p>
 * To enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and in Network Firewall. For
 * information about using Amazon VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon VPC User
 * Guide</a>.
 * </p>
 * <p>
 * To start using Network Firewall, do the following:
 * </p>
 * <ol>
 * <li>
 * <p>
 * (Optional) If you don't already have a VPC that you want to protect, create it in Amazon VPC.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Amazon VPC, in each Availability Zone where you want to have a firewall endpoint, create a subnet for the sole use
 * of Network Firewall.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create stateless and stateful rule groups, to define the components of the network traffic
 * filtering behavior that you want your firewall to have.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create a firewall policy that uses your rule groups and specifies additional default traffic
 * filtering behavior.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Network Firewall, create a firewall and specify your new firewall policy and VPC subnets. Network Firewall creates
 * a firewall endpoint in each subnet that you specify, with the behavior that's defined in the firewall policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * In Amazon VPC, use ingress routing enhancements to route traffic through the new firewall endpoints.
 * </p>
 * </li>
 * </ol>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NetworkFirewallAsyncClient extends AwsClient {
    String SERVICE_NAME = "network-firewall";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "network-firewall";

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     *
     * @param associateFirewallPolicyRequest
     * @return A Java Future containing the result of the AssociateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateFirewallPolicyResponse> associateFirewallPolicy(
            AssociateFirewallPolicyRequest associateFirewallPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFirewallPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param associateFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateFirewallPolicyResponse> associateFirewallPolicy(
            Consumer<AssociateFirewallPolicyRequest.Builder> associateFirewallPolicyRequest) {
        return associateFirewallPolicy(AssociateFirewallPolicyRequest.builder().applyMutation(associateFirewallPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     *
     * @param associateSubnetsRequest
     * @return A Java Future containing the result of the AssociateSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSubnetsResponse> associateSubnets(AssociateSubnetsRequest associateSubnetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSubnetsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateSubnetsRequest#builder()}
     * </p>
     *
     * @param associateSubnetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSubnetsResponse> associateSubnets(
            Consumer<AssociateSubnetsRequest.Builder> associateSubnetsRequest) {
        return associateSubnets(AssociateSubnetsRequest.builder().applyMutation(associateSubnetsRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     *
     * @param createFirewallRequest
     * @return A Java Future containing the result of the CreateFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallResponse> createFirewall(CreateFirewallRequest createFirewallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFirewallRequest#builder()}
     * </p>
     *
     * @param createFirewallRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallResponse> createFirewall(Consumer<CreateFirewallRequest.Builder> createFirewallRequest) {
        return createFirewall(CreateFirewallRequest.builder().applyMutation(createFirewallRequest).build());
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     *
     * @param createFirewallPolicyRequest
     * @return A Java Future containing the result of the CreateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallPolicyResponse> createFirewallPolicy(
            CreateFirewallPolicyRequest createFirewallPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param createFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallPolicyResponse> createFirewallPolicy(
            Consumer<CreateFirewallPolicyRequest.Builder> createFirewallPolicyRequest) {
        return createFirewallPolicy(CreateFirewallPolicyRequest.builder().applyMutation(createFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupResponse> createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRuleGroupRequest#builder()}
     * </p>
     *
     * @param createRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRuleGroupResponse> createRuleGroup(
            Consumer<CreateRuleGroupRequest.Builder> createRuleGroupRequest) {
        return createRuleGroup(CreateRuleGroupRequest.builder().applyMutation(createRuleGroupRequest).build());
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. A TLS inspection configuration contains the Certificate
     * Manager certificate references that Network Firewall uses to decrypt and re-encrypt inbound traffic.
     * </p>
     * <p>
     * After you create a TLS inspection configuration, you associate it with a new firewall policy.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the CreateTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTlsInspectionConfigurationResponse> createTLSInspectionConfiguration(
            CreateTlsInspectionConfigurationRequest createTlsInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. A TLS inspection configuration contains the Certificate
     * Manager certificate references that Network Firewall uses to decrypt and re-encrypt inbound traffic.
     * </p>
     * <p>
     * After you create a TLS inspection configuration, you associate it with a new firewall policy.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>LimitExceededException Unable to perform the operation because doing so would violate a limit
     *         setting.</li>
     *         <li>InsufficientCapacityException Amazon Web Services doesn't currently have enough available capacity to
     *         fulfill your request. Try your request later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTlsInspectionConfigurationResponse> createTLSInspectionConfiguration(
            Consumer<CreateTlsInspectionConfigurationRequest.Builder> createTlsInspectionConfigurationRequest) {
        return createTLSInspectionConfiguration(CreateTlsInspectionConfigurationRequest.builder()
                .applyMutation(createTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     *
     * @param deleteFirewallRequest
     * @return A Java Future containing the result of the DeleteFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallResponse> deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFirewallRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallResponse> deleteFirewall(Consumer<DeleteFirewallRequest.Builder> deleteFirewallRequest) {
        return deleteFirewall(DeleteFirewallRequest.builder().applyMutation(deleteFirewallRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     * @return A Java Future containing the result of the DeleteFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallPolicyResponse> deleteFirewallPolicy(
            DeleteFirewallPolicyRequest deleteFirewallPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallPolicyResponse> deleteFirewallPolicy(
            Consumer<DeleteFirewallPolicyRequest.Builder> deleteFirewallPolicyRequest) {
        return deleteFirewallPolicy(DeleteFirewallPolicyRequest.builder().applyMutation(deleteFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidResourcePolicyException The policy statement failed validation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidResourcePolicyException The policy statement failed validation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>UnsupportedOperationException The operation you requested isn't supported by Network Firewall.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRuleGroupResponse> deleteRuleGroup(
            Consumer<DeleteRuleGroupRequest.Builder> deleteRuleGroupRequest) {
        return deleteRuleGroup(DeleteRuleGroupRequest.builder().applyMutation(deleteRuleGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the DeleteTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTlsInspectionConfigurationResponse> deleteTLSInspectionConfiguration(
            DeleteTlsInspectionConfigurationRequest deleteTlsInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTlsInspectionConfigurationResponse> deleteTLSInspectionConfiguration(
            Consumer<DeleteTlsInspectionConfigurationRequest.Builder> deleteTlsInspectionConfigurationRequest) {
        return deleteTLSInspectionConfiguration(DeleteTlsInspectionConfigurationRequest.builder()
                .applyMutation(deleteTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     *
     * @param describeFirewallRequest
     * @return A Java Future containing the result of the DescribeFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFirewallResponse> describeFirewall(DescribeFirewallRequest describeFirewallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFirewallRequest#builder()}
     * </p>
     *
     * @param describeFirewallRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFirewall operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFirewallResponse> describeFirewall(
            Consumer<DescribeFirewallRequest.Builder> describeFirewallRequest) {
        return describeFirewall(DescribeFirewallRequest.builder().applyMutation(describeFirewallRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     *
     * @param describeFirewallPolicyRequest
     * @return A Java Future containing the result of the DescribeFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFirewallPolicyResponse> describeFirewallPolicy(
            DescribeFirewallPolicyRequest describeFirewallPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param describeFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFirewallPolicyResponse> describeFirewallPolicy(
            Consumer<DescribeFirewallPolicyRequest.Builder> describeFirewallPolicyRequest) {
        return describeFirewallPolicy(DescribeFirewallPolicyRequest.builder().applyMutation(describeFirewallPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     * @return A Java Future containing the result of the DescribeLoggingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingConfigurationResponse> describeLoggingConfiguration(
            DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeLoggingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingConfigurationResponse> describeLoggingConfiguration(
            Consumer<DescribeLoggingConfigurationRequest.Builder> describeLoggingConfigurationRequest) {
        return describeLoggingConfiguration(DescribeLoggingConfigurationRequest.builder()
                .applyMutation(describeLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourcePolicyRequest#builder()}
     * </p>
     *
     * @param describeResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            Consumer<DescribeResourcePolicyRequest.Builder> describeResourcePolicyRequest) {
        return describeResourcePolicy(DescribeResourcePolicyRequest.builder().applyMutation(describeResourcePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     *
     * @param describeRuleGroupRequest
     * @return A Java Future containing the result of the DescribeRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuleGroupResponse> describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRuleGroupRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuleGroupResponse> describeRuleGroup(
            Consumer<DescribeRuleGroupRequest.Builder> describeRuleGroupRequest) {
        return describeRuleGroup(DescribeRuleGroupRequest.builder().applyMutation(describeRuleGroupRequest).build());
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     * @return A Java Future containing the result of the DescribeRuleGroupMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuleGroupMetadataResponse> describeRuleGroupMetadata(
            DescribeRuleGroupMetadataRequest describeRuleGroupMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleGroupMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRuleGroupMetadataRequest#builder()}
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRuleGroupMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuleGroupMetadataResponse> describeRuleGroupMetadata(
            Consumer<DescribeRuleGroupMetadataRequest.Builder> describeRuleGroupMetadataRequest) {
        return describeRuleGroupMetadata(DescribeRuleGroupMetadataRequest.builder()
                .applyMutation(describeRuleGroupMetadataRequest).build());
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the DescribeTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTlsInspectionConfigurationResponse> describeTLSInspectionConfiguration(
            DescribeTlsInspectionConfigurationRequest describeTlsInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTlsInspectionConfigurationResponse> describeTLSInspectionConfiguration(
            Consumer<DescribeTlsInspectionConfigurationRequest.Builder> describeTlsInspectionConfigurationRequest) {
        return describeTLSInspectionConfiguration(DescribeTlsInspectionConfigurationRequest.builder()
                .applyMutation(describeTlsInspectionConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     *
     * @param disassociateSubnetsRequest
     * @return A Java Future containing the result of the DisassociateSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSubnetsResponse> disassociateSubnets(
            DisassociateSubnetsRequest disassociateSubnetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSubnetsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateSubnetsRequest#builder()}
     * </p>
     *
     * @param disassociateSubnetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateSubnets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>InvalidOperationException The operation failed because it's not valid. For example, you might have
     *         tried to delete a rule group or firewall policy that's in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSubnetsResponse> disassociateSubnets(
            Consumer<DisassociateSubnetsRequest.Builder> disassociateSubnetsRequest) {
        return disassociateSubnets(DisassociateSubnetsRequest.builder().applyMutation(disassociateSubnetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return A Java Future containing the result of the ListFirewallPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallPoliciesResponse> listFirewallPolicies(
            ListFirewallPoliciesRequest listFirewallPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFirewallPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallPoliciesResponse> listFirewallPolicies(
            Consumer<ListFirewallPoliciesRequest.Builder> listFirewallPoliciesRequest) {
        return listFirewallPolicies(ListFirewallPoliciesRequest.builder().applyMutation(listFirewallPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesPublisher publisher = client.listFirewallPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesPublisher publisher = client.listFirewallPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesPublisher listFirewallPoliciesPaginator(ListFirewallPoliciesRequest listFirewallPoliciesRequest) {
        return new ListFirewallPoliciesPublisher(this, listFirewallPoliciesRequest);
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesPublisher publisher = client.listFirewallPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallPoliciesPublisher publisher = client.listFirewallPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallPolicies(software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallPoliciesRequest#builder()}
     * </p>
     *
     * @param listFirewallPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallPoliciesPublisher listFirewallPoliciesPaginator(
            Consumer<ListFirewallPoliciesRequest.Builder> listFirewallPoliciesRequest) {
        return listFirewallPoliciesPaginator(ListFirewallPoliciesRequest.builder().applyMutation(listFirewallPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     *
     * @param listFirewallsRequest
     * @return A Java Future containing the result of the ListFirewalls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallsResponse> listFirewalls(ListFirewallsRequest listFirewallsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFirewallsRequest#builder()}
     * </p>
     *
     * @param listFirewallsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFirewalls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallsResponse> listFirewalls(Consumer<ListFirewallsRequest.Builder> listFirewallsRequest) {
        return listFirewalls(ListFirewallsRequest.builder().applyMutation(listFirewallsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsPublisher publisher = client.listFirewallsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsPublisher publisher = client.listFirewallsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation.</b>
     * </p>
     *
     * @param listFirewallsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsPublisher listFirewallsPaginator(ListFirewallsRequest listFirewallsRequest) {
        return new ListFirewallsPublisher(this, listFirewallsRequest);
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsPublisher publisher = client.listFirewallsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListFirewallsPublisher publisher = client.listFirewallsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewalls(software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFirewallsRequest#builder()}
     * </p>
     *
     * @param listFirewallsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallsPublisher listFirewallsPaginator(Consumer<ListFirewallsRequest.Builder> listFirewallsRequest) {
        return listFirewallsPaginator(ListFirewallsRequest.builder().applyMutation(listFirewallsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsResponse> listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRuleGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRuleGroupsResponse> listRuleGroups(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest) {
        return listRuleGroups(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsPublisher publisher = client.listRuleGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsPublisher publisher = client.listRuleGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsPublisher listRuleGroupsPaginator(ListRuleGroupsRequest listRuleGroupsRequest) {
        return new ListRuleGroupsPublisher(this, listRuleGroupsRequest);
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsPublisher publisher = client.listRuleGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListRuleGroupsPublisher publisher = client.listRuleGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleGroups(software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listRuleGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRuleGroupsPublisher listRuleGroupsPaginator(Consumer<ListRuleGroupsRequest.Builder> listRuleGroupsRequest) {
        return listRuleGroupsPaginator(ListRuleGroupsRequest.builder().applyMutation(listRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return A Java Future containing the result of the ListTLSInspectionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTlsInspectionConfigurationsResponse> listTLSInspectionConfigurations(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTlsInspectionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTlsInspectionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListTLSInspectionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTlsInspectionConfigurationsResponse> listTLSInspectionConfigurations(
            Consumer<ListTlsInspectionConfigurationsRequest.Builder> listTlsInspectionConfigurationsRequest) {
        return listTLSInspectionConfigurations(ListTlsInspectionConfigurationsRequest.builder()
                .applyMutation(listTlsInspectionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsPublisher publisher = client.listTLSInspectionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsPublisher publisher = client.listTLSInspectionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTLSInspectionConfigurationsPublisher listTLSInspectionConfigurationsPaginator(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) {
        return new ListTLSInspectionConfigurationsPublisher(this, listTlsInspectionConfigurationsRequest);
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsPublisher publisher = client.listTLSInspectionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTLSInspectionConfigurationsPublisher publisher = client.listTLSInspectionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTLSInspectionConfigurations(software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTlsInspectionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListTlsInspectionConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTLSInspectionConfigurationsPublisher listTLSInspectionConfigurationsPaginator(
            Consumer<ListTlsInspectionConfigurationsRequest.Builder> listTlsInspectionConfigurationsRequest) {
        return listTLSInspectionConfigurationsPaginator(ListTlsInspectionConfigurationsRequest.builder()
                .applyMutation(listTlsInspectionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.networkfirewall.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and
     * firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource
     * Access Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy,
     * you specify the accounts that you want to share the resource with and the operations that you want the accounts
     * to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared rule group or firewall policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidResourcePolicyException The policy statement failed validation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and
     * firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource
     * Access Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy,
     * you specify the accounts that you want to share the resource with and the operations that you want the accounts
     * to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared rule group or firewall policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidResourcePolicyException The policy statement failed validation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     * @return A Java Future containing the result of the UpdateFirewallDeleteProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallDeleteProtectionResponse> updateFirewallDeleteProtection(
            UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDeleteProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFirewallDeleteProtectionRequest#builder()}
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateFirewallDeleteProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallDeleteProtectionResponse> updateFirewallDeleteProtection(
            Consumer<UpdateFirewallDeleteProtectionRequest.Builder> updateFirewallDeleteProtectionRequest) {
        return updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest.builder()
                .applyMutation(updateFirewallDeleteProtectionRequest).build());
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     * @return A Java Future containing the result of the UpdateFirewallDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallDescriptionResponse> updateFirewallDescription(
            UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDescriptionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFirewallDescriptionRequest#builder()}
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateFirewallDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallDescriptionResponse> updateFirewallDescription(
            Consumer<UpdateFirewallDescriptionRequest.Builder> updateFirewallDescriptionRequest) {
        return updateFirewallDescription(UpdateFirewallDescriptionRequest.builder()
                .applyMutation(updateFirewallDescriptionRequest).build());
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     * @return A Java Future containing the result of the UpdateFirewallEncryptionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallEncryptionConfigurationResponse> updateFirewallEncryptionConfiguration(
            UpdateFirewallEncryptionConfigurationRequest updateFirewallEncryptionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFirewallEncryptionConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFirewallEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateFirewallEncryptionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallEncryptionConfigurationResponse> updateFirewallEncryptionConfiguration(
            Consumer<UpdateFirewallEncryptionConfigurationRequest.Builder> updateFirewallEncryptionConfigurationRequest) {
        return updateFirewallEncryptionConfiguration(UpdateFirewallEncryptionConfigurationRequest.builder()
                .applyMutation(updateFirewallEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     *
     * @param updateFirewallPolicyRequest
     * @return A Java Future containing the result of the UpdateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallPolicyResponse> updateFirewallPolicy(
            UpdateFirewallPolicyRequest updateFirewallPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallPolicyRequest#builder()}
     * </p>
     *
     * @param updateFirewallPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateFirewallPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallPolicyResponse> updateFirewallPolicy(
            Consumer<UpdateFirewallPolicyRequest.Builder> updateFirewallPolicyRequest) {
        return updateFirewallPolicy(UpdateFirewallPolicyRequest.builder().applyMutation(updateFirewallPolicyRequest).build());
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     * @return A Java Future containing the result of the UpdateFirewallPolicyChangeProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallPolicyChangeProtectionResponse> updateFirewallPolicyChangeProtection(
            UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateFirewallPolicyChangeProtectionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateFirewallPolicyChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateFirewallPolicyChangeProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallPolicyChangeProtectionResponse> updateFirewallPolicyChangeProtection(
            Consumer<UpdateFirewallPolicyChangeProtectionRequest.Builder> updateFirewallPolicyChangeProtectionRequest) {
        return updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest.builder()
                .applyMutation(updateFirewallPolicyChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     * @return A Java Future containing the result of the UpdateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>LogDestinationPermissionException Unable to send logs to a configured logging destination.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoggingConfigurationResponse> updateLoggingConfiguration(
            UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLoggingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLoggingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>LogDestinationPermissionException Unable to send logs to a configured logging destination.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLoggingConfigurationResponse> updateLoggingConfiguration(
            Consumer<UpdateLoggingConfigurationRequest.Builder> updateLoggingConfigurationRequest) {
        return updateLoggingConfiguration(UpdateLoggingConfigurationRequest.builder()
                .applyMutation(updateLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleGroupRequest#builder()}
     * </p>
     *
     * @param updateRuleGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRuleGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleGroupResponse> updateRuleGroup(
            Consumer<UpdateRuleGroupRequest.Builder> updateRuleGroupRequest) {
        return updateRuleGroup(UpdateRuleGroupRequest.builder().applyMutation(updateRuleGroupRequest).build());
    }

    /**
     * <p/>
     *
     * @param updateSubnetChangeProtectionRequest
     * @return A Java Future containing the result of the UpdateSubnetChangeProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubnetChangeProtectionResponse> updateSubnetChangeProtection(
            UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubnetChangeProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubnetChangeProtectionRequest#builder()}
     * </p>
     *
     * @param updateSubnetChangeProtectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateSubnetChangeProtection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>ResourceOwnerCheckException Unable to change the resource because your account doesn't own it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSubnetChangeProtectionResponse> updateSubnetChangeProtection(
            Consumer<UpdateSubnetChangeProtectionRequest.Builder> updateSubnetChangeProtectionRequest) {
        return updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest.builder()
                .applyMutation(updateSubnetChangeProtectionRequest).build());
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by reference in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     * @return A Java Future containing the result of the UpdateTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTlsInspectionConfigurationResponse> updateTLSInspectionConfiguration(
            UpdateTlsInspectionConfigurationRequest updateTlsInspectionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by reference in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTlsInspectionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTlsInspectionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateTLSInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The operation failed because of a problem with your request. Examples
     *         include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException Unable to locate a resource using the parameters that you provided.</li>
     *         <li>ThrottlingException Unable to process the request due to throttling limitations.</li>
     *         <li>InternalServerErrorException Your request is valid, but Network Firewall couldn’t perform the
     *         operation because of a system problem. Retry your request.</li>
     *         <li>InvalidTokenException The token you provided is stale or isn't valid for the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NetworkFirewallException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample NetworkFirewallAsyncClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTlsInspectionConfigurationResponse> updateTLSInspectionConfiguration(
            Consumer<UpdateTlsInspectionConfigurationRequest.Builder> updateTlsInspectionConfigurationRequest) {
        return updateTLSInspectionConfiguration(UpdateTlsInspectionConfigurationRequest.builder()
                .applyMutation(updateTlsInspectionConfigurationRequest).build());
    }

    @Override
    default NetworkFirewallServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NetworkFirewallAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NetworkFirewallAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NetworkFirewallAsyncClient}.
     */
    static NetworkFirewallAsyncClientBuilder builder() {
        return new DefaultNetworkFirewallAsyncClientBuilder();
    }
}
