/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTlsInspectionConfigurationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<CreateTlsInspectionConfigurationRequest.Builder, CreateTlsInspectionConfigurationRequest> {
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationName")
            .getter(getter(CreateTlsInspectionConfigurationRequest::tlsInspectionConfigurationName))
            .setter(setter(Builder::tlsInspectionConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationName")
                    .build()).build();

    private static final SdkField<TLSInspectionConfiguration> TLS_INSPECTION_CONFIGURATION_FIELD = SdkField
            .<TLSInspectionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TLSInspectionConfiguration")
            .getter(getter(CreateTlsInspectionConfigurationRequest::tlsInspectionConfiguration))
            .setter(setter(Builder::tlsInspectionConfiguration))
            .constructor(TLSInspectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateTlsInspectionConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTlsInspectionConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(CreateTlsInspectionConfigurationRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TLS_INSPECTION_CONFIGURATION_NAME_FIELD, TLS_INSPECTION_CONFIGURATION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD));

    private final String tlsInspectionConfigurationName;

    private final TLSInspectionConfiguration tlsInspectionConfiguration;

    private final String description;

    private final List<Tag> tags;

    private final EncryptionConfiguration encryptionConfiguration;

    private CreateTlsInspectionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tlsInspectionConfigurationName = builder.tlsInspectionConfigurationName;
        this.tlsInspectionConfiguration = builder.tlsInspectionConfiguration;
        this.description = builder.description;
        this.tags = builder.tags;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     * configuration after you create it.
     * </p>
     * 
     * @return The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     *         configuration after you create it.
     */
    public final String tlsInspectionConfigurationName() {
        return tlsInspectionConfigurationName;
    }

    /**
     * <p>
     * The object that defines a TLS inspection configuration. This, along with
     * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects
     * for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic
     * before sending it to its destination.
     * </p>
     * <p>
     * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the
     * firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic.
     * You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall
     * policy in more than one firewall. For more information about using TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * 
     * @return The object that defines a TLS inspection configuration. This, along with
     *         <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
     *         objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>
     *         <p>
     *         Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
     *         traffic before sending it to its destination.
     *         </p>
     *         <p>
     *         To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you
     *         apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect
     *         inbound traffic. You can reference a TLS inspection configuration from more than one firewall policy, and
     *         you can use a firewall policy in more than one firewall. For more information about using TLS inspection
     *         configurations, see <a
     *         href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
     *         SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     */
    public final TLSInspectionConfiguration tlsInspectionConfiguration() {
        return tlsInspectionConfiguration;
    }

    /**
     * <p>
     * A description of the TLS inspection configuration.
     * </p>
     * 
     * @return A description of the TLS inspection configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the EncryptionConfiguration property for this object.
     * 
     * @return The value of the EncryptionConfiguration property for this object.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTlsInspectionConfigurationRequest)) {
            return false;
        }
        CreateTlsInspectionConfigurationRequest other = (CreateTlsInspectionConfigurationRequest) obj;
        return Objects.equals(tlsInspectionConfigurationName(), other.tlsInspectionConfigurationName())
                && Objects.equals(tlsInspectionConfiguration(), other.tlsInspectionConfiguration())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTlsInspectionConfigurationRequest")
                .add("TLSInspectionConfigurationName", tlsInspectionConfigurationName())
                .add("TLSInspectionConfiguration", tlsInspectionConfiguration()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TLSInspectionConfigurationName":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationName()));
        case "TLSInspectionConfiguration":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTlsInspectionConfigurationRequest, T> g) {
        return obj -> g.apply((CreateTlsInspectionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTlsInspectionConfigurationRequest> {
        /**
         * <p>
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
         * configuration after you create it.
         * </p>
         * 
         * @param tlsInspectionConfigurationName
         *        The descriptive name of the TLS inspection configuration. You can't change the name of a TLS
         *        inspection configuration after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName);

        /**
         * <p>
         * The object that defines a TLS inspection configuration. This, along with
         * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
         * objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * <p>
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
         * traffic before sending it to its destination.
         * </p>
         * <p>
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply
         * the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound
         * traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use
         * a firewall policy in more than one firewall. For more information about using TLS inspection configurations,
         * see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
         * SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param tlsInspectionConfiguration
         *        The object that defines a TLS inspection configuration. This, along with
         *        <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve
         *        all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         *        </p>
         *        <p>
         *        Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts
         *        the traffic before sending it to its destination.
         *        </p>
         *        <p>
         *        To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you
         *        apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and
         *        inspect inbound traffic. You can reference a TLS inspection configuration from more than one firewall
         *        policy, and you can use a firewall policy in more than one firewall. For more information about using
         *        TLS inspection configurations, see <a
         *        href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html"
         *        >Decrypting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration);

        /**
         * <p>
         * The object that defines a TLS inspection configuration. This, along with
         * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
         * objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * <p>
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
         * traffic before sending it to its destination.
         * </p>
         * <p>
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply
         * the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound
         * traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use
         * a firewall policy in more than one firewall. For more information about using TLS inspection configurations,
         * see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
         * SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TLSInspectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link TLSInspectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLSInspectionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #tlsInspectionConfiguration(TLSInspectionConfiguration)}.
         * 
         * @param tlsInspectionConfiguration
         *        a consumer that will call methods on {@link TLSInspectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInspectionConfiguration(TLSInspectionConfiguration)
         */
        default Builder tlsInspectionConfiguration(Consumer<TLSInspectionConfiguration.Builder> tlsInspectionConfiguration) {
            return tlsInspectionConfiguration(TLSInspectionConfiguration.builder().applyMutation(tlsInspectionConfiguration)
                    .build());
        }

        /**
         * <p>
         * A description of the TLS inspection configuration.
         * </p>
         * 
         * @param description
         *        A description of the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * @param encryptionConfiguration
         *        The new value for the EncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String tlsInspectionConfigurationName;

        private TLSInspectionConfiguration tlsInspectionConfiguration;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTlsInspectionConfigurationRequest model) {
            super(model);
            tlsInspectionConfigurationName(model.tlsInspectionConfigurationName);
            tlsInspectionConfiguration(model.tlsInspectionConfiguration);
            description(model.description);
            tags(model.tags);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getTlsInspectionConfigurationName() {
            return tlsInspectionConfigurationName;
        }

        public final void setTlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
        }

        @Override
        public final Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        public final TLSInspectionConfiguration.Builder getTlsInspectionConfiguration() {
            return tlsInspectionConfiguration != null ? tlsInspectionConfiguration.toBuilder() : null;
        }

        public final void setTlsInspectionConfiguration(TLSInspectionConfiguration.BuilderImpl tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration != null ? tlsInspectionConfiguration.build() : null;
        }

        @Override
        public final Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTlsInspectionConfigurationRequest build() {
            return new CreateTlsInspectionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
