/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRuleGroupResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DeleteRuleGroupResponse.Builder, DeleteRuleGroupResponse> {
    private static final SdkField<RuleGroupResponse> RULE_GROUP_RESPONSE_FIELD = SdkField
            .<RuleGroupResponse> builder(MarshallingType.SDK_POJO).memberName("RuleGroupResponse")
            .getter(getter(DeleteRuleGroupResponse::ruleGroupResponse)).setter(setter(Builder::ruleGroupResponse))
            .constructor(RuleGroupResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_RESPONSE_FIELD));

    private final RuleGroupResponse ruleGroupResponse;

    private DeleteRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.ruleGroupResponse = builder.ruleGroupResponse;
    }

    /**
     * <p>
     * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can
     * retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
     * </p>
     * 
     * @return The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group.
     *         You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
     */
    public final RuleGroupResponse ruleGroupResponse() {
        return ruleGroupResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRuleGroupResponse)) {
            return false;
        }
        DeleteRuleGroupResponse other = (DeleteRuleGroupResponse) obj;
        return Objects.equals(ruleGroupResponse(), other.ruleGroupResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRuleGroupResponse").add("RuleGroupResponse", ruleGroupResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroupResponse":
            return Optional.ofNullable(clazz.cast(ruleGroupResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRuleGroupResponse, T> g) {
        return obj -> g.apply((DeleteRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRuleGroupResponse> {
        /**
         * <p>
         * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You
         * can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * </p>
         * 
         * @param ruleGroupResponse
         *        The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule
         *        group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupResponse(RuleGroupResponse ruleGroupResponse);

        /**
         * <p>
         * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You
         * can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupResponse.Builder} avoiding the
         * need to create one manually via {@link RuleGroupResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleGroupResponse(RuleGroupResponse)}.
         * 
         * @param ruleGroupResponse
         *        a consumer that will call methods on {@link RuleGroupResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupResponse(RuleGroupResponse)
         */
        default Builder ruleGroupResponse(Consumer<RuleGroupResponse.Builder> ruleGroupResponse) {
            return ruleGroupResponse(RuleGroupResponse.builder().applyMutation(ruleGroupResponse).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private RuleGroupResponse ruleGroupResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRuleGroupResponse model) {
            super(model);
            ruleGroupResponse(model.ruleGroupResponse);
        }

        public final RuleGroupResponse.Builder getRuleGroupResponse() {
            return ruleGroupResponse != null ? ruleGroupResponse.toBuilder() : null;
        }

        public final void setRuleGroupResponse(RuleGroupResponse.BuilderImpl ruleGroupResponse) {
            this.ruleGroupResponse = ruleGroupResponse != null ? ruleGroupResponse.build() : null;
        }

        @Override
        public final Builder ruleGroupResponse(RuleGroupResponse ruleGroupResponse) {
            this.ruleGroupResponse = ruleGroupResponse;
            return this;
        }

        @Override
        public DeleteRuleGroupResponse build() {
            return new DeleteRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
