/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that defines a TLS inspection configuration. This, along with <a>TLSInspectionConfigurationResponse</a>,
 * define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling
 * <a>DescribeTLSInspectionConfiguration</a>.
 * </p>
 * <p>
 * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic
 * before sending it to its destination.
 * </p>
 * <p>
 * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the
 * firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic. You
 * can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in
 * more than one firewall. For more information about using TLS inspection configurations, see <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
 * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TLSInspectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TLSInspectionConfiguration.Builder, TLSInspectionConfiguration> {
    private static final SdkField<List<ServerCertificateConfiguration>> SERVER_CERTIFICATE_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerCertificateConfiguration>> builder(MarshallingType.LIST)
            .memberName("ServerCertificateConfigurations")
            .getter(getter(TLSInspectionConfiguration::serverCertificateConfigurations))
            .setter(setter(Builder::serverCertificateConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerCertificateConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerCertificateConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVER_CERTIFICATE_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ServerCertificateConfiguration> serverCertificateConfigurations;

    private TLSInspectionConfiguration(BuilderImpl builder) {
        this.serverCertificateConfigurations = builder.serverCertificateConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerCertificateConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasServerCertificateConfigurations() {
        return serverCertificateConfigurations != null && !(serverCertificateConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the server certificate configurations that are associated with the TLS configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerCertificateConfigurations}
     * method.
     * </p>
     * 
     * @return Lists the server certificate configurations that are associated with the TLS configuration.
     */
    public final List<ServerCertificateConfiguration> serverCertificateConfigurations() {
        return serverCertificateConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasServerCertificateConfigurations() ? serverCertificateConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TLSInspectionConfiguration)) {
            return false;
        }
        TLSInspectionConfiguration other = (TLSInspectionConfiguration) obj;
        return hasServerCertificateConfigurations() == other.hasServerCertificateConfigurations()
                && Objects.equals(serverCertificateConfigurations(), other.serverCertificateConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TLSInspectionConfiguration")
                .add("ServerCertificateConfigurations",
                        hasServerCertificateConfigurations() ? serverCertificateConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificateConfigurations":
            return Optional.ofNullable(clazz.cast(serverCertificateConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TLSInspectionConfiguration, T> g) {
        return obj -> g.apply((TLSInspectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TLSInspectionConfiguration> {
        /**
         * <p>
         * Lists the server certificate configurations that are associated with the TLS configuration.
         * </p>
         * 
         * @param serverCertificateConfigurations
         *        Lists the server certificate configurations that are associated with the TLS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateConfigurations(Collection<ServerCertificateConfiguration> serverCertificateConfigurations);

        /**
         * <p>
         * Lists the server certificate configurations that are associated with the TLS configuration.
         * </p>
         * 
         * @param serverCertificateConfigurations
         *        Lists the server certificate configurations that are associated with the TLS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateConfigurations(ServerCertificateConfiguration... serverCertificateConfigurations);

        /**
         * <p>
         * Lists the server certificate configurations that are associated with the TLS configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #serverCertificateConfigurations(List<ServerCertificateConfiguration>)}.
         * 
         * @param serverCertificateConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificateConfigurations(java.util.Collection<ServerCertificateConfiguration>)
         */
        Builder serverCertificateConfigurations(
                Consumer<ServerCertificateConfiguration.Builder>... serverCertificateConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<ServerCertificateConfiguration> serverCertificateConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TLSInspectionConfiguration model) {
            serverCertificateConfigurations(model.serverCertificateConfigurations);
        }

        public final List<ServerCertificateConfiguration.Builder> getServerCertificateConfigurations() {
            List<ServerCertificateConfiguration.Builder> result = ServerCertificateConfigurationsCopier
                    .copyToBuilder(this.serverCertificateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerCertificateConfigurations(
                Collection<ServerCertificateConfiguration.BuilderImpl> serverCertificateConfigurations) {
            this.serverCertificateConfigurations = ServerCertificateConfigurationsCopier
                    .copyFromBuilder(serverCertificateConfigurations);
        }

        @Override
        public final Builder serverCertificateConfigurations(
                Collection<ServerCertificateConfiguration> serverCertificateConfigurations) {
            this.serverCertificateConfigurations = ServerCertificateConfigurationsCopier.copy(serverCertificateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateConfigurations(ServerCertificateConfiguration... serverCertificateConfigurations) {
            serverCertificateConfigurations(Arrays.asList(serverCertificateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateConfigurations(
                Consumer<ServerCertificateConfiguration.Builder>... serverCertificateConfigurations) {
            serverCertificateConfigurations(Stream.of(serverCertificateConfigurations)
                    .map(c -> ServerCertificateConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TLSInspectionConfiguration build() {
            return new TLSInspectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
