/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTlsInspectionConfigurationRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<UpdateTlsInspectionConfigurationRequest.Builder, UpdateTlsInspectionConfigurationRequest> {
    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationArn")
            .getter(getter(UpdateTlsInspectionConfigurationRequest::tlsInspectionConfigurationArn))
            .setter(setter(Builder::tlsInspectionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn")
                    .build()).build();

    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationName")
            .getter(getter(UpdateTlsInspectionConfigurationRequest::tlsInspectionConfigurationName))
            .setter(setter(Builder::tlsInspectionConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationName")
                    .build()).build();

    private static final SdkField<TLSInspectionConfiguration> TLS_INSPECTION_CONFIGURATION_FIELD = SdkField
            .<TLSInspectionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TLSInspectionConfiguration")
            .getter(getter(UpdateTlsInspectionConfigurationRequest::tlsInspectionConfiguration))
            .setter(setter(Builder::tlsInspectionConfiguration))
            .constructor(TLSInspectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateTlsInspectionConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(UpdateTlsInspectionConfigurationRequest::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(UpdateTlsInspectionConfigurationRequest::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TLS_INSPECTION_CONFIGURATION_ARN_FIELD, TLS_INSPECTION_CONFIGURATION_NAME_FIELD, TLS_INSPECTION_CONFIGURATION_FIELD,
            DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, UPDATE_TOKEN_FIELD));

    private final String tlsInspectionConfigurationArn;

    private final String tlsInspectionConfigurationName;

    private final TLSInspectionConfiguration tlsInspectionConfiguration;

    private final String description;

    private final EncryptionConfiguration encryptionConfiguration;

    private final String updateToken;

    private UpdateTlsInspectionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.tlsInspectionConfigurationName = builder.tlsInspectionConfigurationName;
        this.tlsInspectionConfiguration = builder.tlsInspectionConfiguration;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the TLS inspection configuration.
     */
    public final String tlsInspectionConfigurationArn() {
        return tlsInspectionConfigurationArn;
    }

    /**
     * <p>
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     * configuration after you create it.
     * </p>
     * 
     * @return The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
     *         configuration after you create it.
     */
    public final String tlsInspectionConfigurationName() {
        return tlsInspectionConfigurationName;
    }

    /**
     * <p>
     * The object that defines a TLS inspection configuration. This, along with
     * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all objects
     * for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic
     * before sending it to its destination.
     * </p>
     * <p>
     * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the
     * firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic.
     * You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall
     * policy in more than one firewall. For more information about using TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * 
     * @return The object that defines a TLS inspection configuration. This, along with
     *         <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
     *         objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>. </p>
     *         <p>
     *         Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
     *         traffic before sending it to its destination.
     *         </p>
     *         <p>
     *         To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you
     *         apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect
     *         inbound traffic. You can reference a TLS inspection configuration from more than one firewall policy, and
     *         you can use a firewall policy in more than one firewall. For more information about using TLS inspection
     *         configurations, see <a
     *         href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
     *         SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     */
    public final TLSInspectionConfiguration tlsInspectionConfiguration() {
        return tlsInspectionConfiguration;
    }

    /**
     * <p>
     * A description of the TLS inspection configuration.
     * </p>
     * 
     * @return A description of the TLS inspection configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
     * inspection configuration.
     * </p>
     * 
     * @return A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
     *         inspection configuration.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS
     * inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of
     * the request.
     * </p>
     * <p>
     * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses
     * the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If it has
     * changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the TLS
     * inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed,
     * then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at
     *         the time of the request. </p>
     *         <p>
     *         To make changes to the TLS inspection configuration, you provide the token in your request. Network
     *         Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last
     *         retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If this
     *         happens, retrieve the TLS inspection configuration again to get a current copy of it with a current
     *         token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTlsInspectionConfigurationRequest)) {
            return false;
        }
        UpdateTlsInspectionConfigurationRequest other = (UpdateTlsInspectionConfigurationRequest) obj;
        return Objects.equals(tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn())
                && Objects.equals(tlsInspectionConfigurationName(), other.tlsInspectionConfigurationName())
                && Objects.equals(tlsInspectionConfiguration(), other.tlsInspectionConfiguration())
                && Objects.equals(description(), other.description())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTlsInspectionConfigurationRequest")
                .add("TLSInspectionConfigurationArn", tlsInspectionConfigurationArn())
                .add("TLSInspectionConfigurationName", tlsInspectionConfigurationName())
                .add("TLSInspectionConfiguration", tlsInspectionConfiguration()).add("Description", description())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TLSInspectionConfigurationArn":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationArn()));
        case "TLSInspectionConfigurationName":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationName()));
        case "TLSInspectionConfiguration":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTlsInspectionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateTlsInspectionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTlsInspectionConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * </p>
         * 
         * @param tlsInspectionConfigurationArn
         *        The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn);

        /**
         * <p>
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection
         * configuration after you create it.
         * </p>
         * 
         * @param tlsInspectionConfigurationName
         *        The descriptive name of the TLS inspection configuration. You can't change the name of a TLS
         *        inspection configuration after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName);

        /**
         * <p>
         * The object that defines a TLS inspection configuration. This, along with
         * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
         * objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * <p>
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
         * traffic before sending it to its destination.
         * </p>
         * <p>
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply
         * the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound
         * traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use
         * a firewall policy in more than one firewall. For more information about using TLS inspection configurations,
         * see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
         * SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param tlsInspectionConfiguration
         *        The object that defines a TLS inspection configuration. This, along with
         *        <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve
         *        all objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         *        </p>
         *        <p>
         *        Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts
         *        the traffic before sending it to its destination.
         *        </p>
         *        <p>
         *        To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you
         *        apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and
         *        inspect inbound traffic. You can reference a TLS inspection configuration from more than one firewall
         *        policy, and you can use a firewall policy in more than one firewall. For more information about using
         *        TLS inspection configurations, see <a
         *        href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html"
         *        >Decrypting SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration);

        /**
         * <p>
         * The object that defines a TLS inspection configuration. This, along with
         * <a>TLSInspectionConfigurationResponse</a>, define the TLS inspection configuration. You can retrieve all
         * objects for a TLS inspection configuration by calling <a>DescribeTLSInspectionConfiguration</a>.
         * </p>
         * <p>
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the
         * traffic before sending it to its destination.
         * </p>
         * <p>
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply
         * the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound
         * traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use
         * a firewall policy in more than one firewall. For more information about using TLS inspection configurations,
         * see <a
         * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Decrypting
         * SSL/TLS traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TLSInspectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link TLSInspectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLSInspectionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #tlsInspectionConfiguration(TLSInspectionConfiguration)}.
         * 
         * @param tlsInspectionConfiguration
         *        a consumer that will call methods on {@link TLSInspectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsInspectionConfiguration(TLSInspectionConfiguration)
         */
        default Builder tlsInspectionConfiguration(Consumer<TLSInspectionConfiguration.Builder> tlsInspectionConfiguration) {
            return tlsInspectionConfiguration(TLSInspectionConfiguration.builder().applyMutation(tlsInspectionConfiguration)
                    .build());
        }

        /**
         * <p>
         * A description of the TLS inspection configuration.
         * </p>
         * 
         * @param description
         *        A description of the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
         * inspection configuration.
         * </p>
         * 
         * @param encryptionConfiguration
         *        A complex type that contains the Amazon Web Services KMS encryption configuration settings for your
         *        TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS
         * inspection configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS
         * inspection configuration. The token marks the state of the TLS inspection configuration resource at the time
         * of the request.
         * </p>
         * <p>
         * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall
         * uses the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If
         * it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the
         * TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as
         * needed, then try the operation again using the new token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        TLS inspection configuration. The token marks the state of the TLS inspection configuration resource
         *        at the time of the request. </p>
         *        <p>
         *        To make changes to the TLS inspection configuration, you provide the token in your request. Network
         *        Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last
         *        retrieved it. If it has changed, the operation fails with an <code>InvalidTokenException</code>. If
         *        this happens, retrieve the TLS inspection configuration again to get a current copy of it with a
         *        current token. Reapply your changes as needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String tlsInspectionConfigurationArn;

        private String tlsInspectionConfigurationName;

        private TLSInspectionConfiguration tlsInspectionConfiguration;

        private String description;

        private EncryptionConfiguration encryptionConfiguration;

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTlsInspectionConfigurationRequest model) {
            super(model);
            tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            tlsInspectionConfigurationName(model.tlsInspectionConfigurationName);
            tlsInspectionConfiguration(model.tlsInspectionConfiguration);
            description(model.description);
            encryptionConfiguration(model.encryptionConfiguration);
            updateToken(model.updateToken);
        }

        public final String getTlsInspectionConfigurationArn() {
            return tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final String getTlsInspectionConfigurationName() {
            return tlsInspectionConfigurationName;
        }

        public final void setTlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
        }

        @Override
        public final Builder tlsInspectionConfigurationName(String tlsInspectionConfigurationName) {
            this.tlsInspectionConfigurationName = tlsInspectionConfigurationName;
            return this;
        }

        public final TLSInspectionConfiguration.Builder getTlsInspectionConfiguration() {
            return tlsInspectionConfiguration != null ? tlsInspectionConfiguration.toBuilder() : null;
        }

        public final void setTlsInspectionConfiguration(TLSInspectionConfiguration.BuilderImpl tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration != null ? tlsInspectionConfiguration.build() : null;
        }

        @Override
        public final Builder tlsInspectionConfiguration(TLSInspectionConfiguration tlsInspectionConfiguration) {
            this.tlsInspectionConfiguration = tlsInspectionConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTlsInspectionConfigurationRequest build() {
            return new UpdateTlsInspectionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
