/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProxyConfigurationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, DeleteProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(DeleteProxyConfigurationRequest.getter(DeleteProxyConfigurationRequest::proxyConfigurationName)).setter(DeleteProxyConfigurationRequest.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(DeleteProxyConfigurationRequest.getter(DeleteProxyConfigurationRequest::proxyConfigurationArn)).setter(DeleteProxyConfigurationRequest.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteProxyConfigurationRequest.memberNameToFieldInitializer();
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;

    private DeleteProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProxyConfigurationRequest)) {
            return false;
        }
        DeleteProxyConfigurationRequest other = (DeleteProxyConfigurationRequest)((Object)obj);
        return Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProxyConfigurationRequest").add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteProxyConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteProxyConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyConfigurationName;
        private String proxyConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProxyConfigurationRequest model) {
            super(model);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProxyConfigurationRequest build() {
            return new DeleteProxyConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProxyConfigurationRequest> {
        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

