/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.Address;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Flow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Flow> {
    private static final SdkField<Address> SOURCE_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceAddress").getter(Flow.getter(Flow::sourceAddress)).setter(Flow.setter(Builder::sourceAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress").build()}).build();
    private static final SdkField<Address> DESTINATION_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationAddress").getter(Flow.getter(Flow::destinationAddress)).setter(Flow.setter(Builder::destinationAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").build()}).build();
    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePort").getter(Flow.getter(Flow::sourcePort)).setter(Flow.setter(Builder::sourcePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()}).build();
    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPort").getter(Flow.getter(Flow::destinationPort)).setter(Flow.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Flow.getter(Flow::protocol)).setter(Flow.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> AGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Age").getter(Flow.getter(Flow::age)).setter(Flow.setter(Builder::age)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Age").build()}).build();
    private static final SdkField<Integer> PACKET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PacketCount").getter(Flow.getter(Flow::packetCount)).setter(Flow.setter(Builder::packetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketCount").build()}).build();
    private static final SdkField<Long> BYTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ByteCount").getter(Flow.getter(Flow::byteCount)).setter(Flow.setter(Builder::byteCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD, DESTINATION_ADDRESS_FIELD, SOURCE_PORT_FIELD, DESTINATION_PORT_FIELD, PROTOCOL_FIELD, AGE_FIELD, PACKET_COUNT_FIELD, BYTE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Flow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Address sourceAddress;
    private final Address destinationAddress;
    private final String sourcePort;
    private final String destinationPort;
    private final String protocol;
    private final Integer age;
    private final Integer packetCount;
    private final Long byteCount;

    private Flow(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.destinationAddress = builder.destinationAddress;
        this.sourcePort = builder.sourcePort;
        this.destinationPort = builder.destinationPort;
        this.protocol = builder.protocol;
        this.age = builder.age;
        this.packetCount = builder.packetCount;
        this.byteCount = builder.byteCount;
    }

    public final Address sourceAddress() {
        return this.sourceAddress;
    }

    public final Address destinationAddress() {
        return this.destinationAddress;
    }

    public final String sourcePort() {
        return this.sourcePort;
    }

    public final String destinationPort() {
        return this.destinationPort;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final Integer age() {
        return this.age;
    }

    public final Integer packetCount() {
        return this.packetCount;
    }

    public final Long byteCount() {
        return this.byteCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.age());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.byteCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)obj;
        return Objects.equals(this.sourceAddress(), other.sourceAddress()) && Objects.equals(this.destinationAddress(), other.destinationAddress()) && Objects.equals(this.sourcePort(), other.sourcePort()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.age(), other.age()) && Objects.equals(this.packetCount(), other.packetCount()) && Objects.equals(this.byteCount(), other.byteCount());
    }

    public final String toString() {
        return ToString.builder((String)"Flow").add("SourceAddress", (Object)this.sourceAddress()).add("DestinationAddress", (Object)this.destinationAddress()).add("SourcePort", (Object)this.sourcePort()).add("DestinationPort", (Object)this.destinationPort()).add("Protocol", (Object)this.protocol()).add("Age", (Object)this.age()).add("PacketCount", (Object)this.packetCount()).add("ByteCount", (Object)this.byteCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAddress": {
                return Optional.ofNullable(clazz.cast(this.sourceAddress()));
            }
            case "DestinationAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationAddress()));
            }
            case "SourcePort": {
                return Optional.ofNullable(clazz.cast(this.sourcePort()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Age": {
                return Optional.ofNullable(clazz.cast(this.age()));
            }
            case "PacketCount": {
                return Optional.ofNullable(clazz.cast(this.packetCount()));
            }
            case "ByteCount": {
                return Optional.ofNullable(clazz.cast(this.byteCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("SourcePort", SOURCE_PORT_FIELD);
        map.put("DestinationPort", DESTINATION_PORT_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Age", AGE_FIELD);
        map.put("PacketCount", PACKET_COUNT_FIELD);
        map.put("ByteCount", BYTE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Flow, T> g) {
        return obj -> g.apply((Flow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Address sourceAddress;
        private Address destinationAddress;
        private String sourcePort;
        private String destinationPort;
        private String protocol;
        private Integer age;
        private Integer packetCount;
        private Long byteCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Flow model) {
            this.sourceAddress(model.sourceAddress);
            this.destinationAddress(model.destinationAddress);
            this.sourcePort(model.sourcePort);
            this.destinationPort(model.destinationPort);
            this.protocol(model.protocol);
            this.age(model.age);
            this.packetCount(model.packetCount);
            this.byteCount(model.byteCount);
        }

        public final Address.Builder getSourceAddress() {
            return this.sourceAddress != null ? this.sourceAddress.toBuilder() : null;
        }

        public final void setSourceAddress(Address.BuilderImpl sourceAddress) {
            this.sourceAddress = sourceAddress != null ? sourceAddress.build() : null;
        }

        @Override
        public final Builder sourceAddress(Address sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final Address.Builder getDestinationAddress() {
            return this.destinationAddress != null ? this.destinationAddress.toBuilder() : null;
        }

        public final void setDestinationAddress(Address.BuilderImpl destinationAddress) {
            this.destinationAddress = destinationAddress != null ? destinationAddress.build() : null;
        }

        @Override
        public final Builder destinationAddress(Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final String getSourcePort() {
            return this.sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Integer getAge() {
            return this.age;
        }

        public final void setAge(Integer age) {
            this.age = age;
        }

        @Override
        public final Builder age(Integer age) {
            this.age = age;
            return this;
        }

        public final Integer getPacketCount() {
            return this.packetCount;
        }

        public final void setPacketCount(Integer packetCount) {
            this.packetCount = packetCount;
        }

        @Override
        public final Builder packetCount(Integer packetCount) {
            this.packetCount = packetCount;
            return this;
        }

        public final Long getByteCount() {
            return this.byteCount;
        }

        public final void setByteCount(Long byteCount) {
            this.byteCount = byteCount;
        }

        @Override
        public final Builder byteCount(Long byteCount) {
            this.byteCount = byteCount;
            return this;
        }

        public Flow build() {
            return new Flow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Flow> {
        public Builder sourceAddress(Address var1);

        default public Builder sourceAddress(Consumer<Address.Builder> sourceAddress) {
            return this.sourceAddress((Address)((Address.Builder)Address.builder().applyMutation(sourceAddress)).build());
        }

        public Builder destinationAddress(Address var1);

        default public Builder destinationAddress(Consumer<Address.Builder> destinationAddress) {
            return this.destinationAddress((Address)((Address.Builder)Address.builder().applyMutation(destinationAddress)).build());
        }

        public Builder sourcePort(String var1);

        public Builder destinationPort(String var1);

        public Builder protocol(String var1);

        public Builder age(Integer var1);

        public Builder packetCount(Integer var1);

        public Builder byteCount(Long var1);
    }
}

