/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.Address;
import software.amazon.awssdk.services.networkfirewall.model.ProtocolStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowFilter> {
    private static final SdkField<Address> SOURCE_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceAddress").getter(FlowFilter.getter(FlowFilter::sourceAddress)).setter(FlowFilter.setter(Builder::sourceAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress").build()}).build();
    private static final SdkField<Address> DESTINATION_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationAddress").getter(FlowFilter.getter(FlowFilter::destinationAddress)).setter(FlowFilter.setter(Builder::destinationAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress").build()}).build();
    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePort").getter(FlowFilter.getter(FlowFilter::sourcePort)).setter(FlowFilter.setter(Builder::sourcePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()}).build();
    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPort").getter(FlowFilter.getter(FlowFilter::destinationPort)).setter(FlowFilter.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(FlowFilter.getter(FlowFilter::protocols)).setter(FlowFilter.setter(Builder::protocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD, DESTINATION_ADDRESS_FIELD, SOURCE_PORT_FIELD, DESTINATION_PORT_FIELD, PROTOCOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Address sourceAddress;
    private final Address destinationAddress;
    private final String sourcePort;
    private final String destinationPort;
    private final List<String> protocols;

    private FlowFilter(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.destinationAddress = builder.destinationAddress;
        this.sourcePort = builder.sourcePort;
        this.destinationPort = builder.destinationPort;
        this.protocols = builder.protocols;
    }

    public final Address sourceAddress() {
        return this.sourceAddress;
    }

    public final Address destinationAddress() {
        return this.destinationAddress;
    }

    public final String sourcePort() {
        return this.sourcePort;
    }

    public final String destinationPort() {
        return this.destinationPort;
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocols() {
        return this.protocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocols() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowFilter)) {
            return false;
        }
        FlowFilter other = (FlowFilter)obj;
        return Objects.equals(this.sourceAddress(), other.sourceAddress()) && Objects.equals(this.destinationAddress(), other.destinationAddress()) && Objects.equals(this.sourcePort(), other.sourcePort()) && Objects.equals(this.destinationPort(), other.destinationPort()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocols(), other.protocols());
    }

    public final String toString() {
        return ToString.builder((String)"FlowFilter").add("SourceAddress", (Object)this.sourceAddress()).add("DestinationAddress", (Object)this.destinationAddress()).add("SourcePort", (Object)this.sourcePort()).add("DestinationPort", (Object)this.destinationPort()).add("Protocols", this.hasProtocols() ? this.protocols() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAddress": {
                return Optional.ofNullable(clazz.cast(this.sourceAddress()));
            }
            case "DestinationAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationAddress()));
            }
            case "SourcePort": {
                return Optional.ofNullable(clazz.cast(this.sourcePort()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocols()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("DestinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("SourcePort", SOURCE_PORT_FIELD);
        map.put("DestinationPort", DESTINATION_PORT_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowFilter, T> g) {
        return obj -> g.apply((FlowFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Address sourceAddress;
        private Address destinationAddress;
        private String sourcePort;
        private String destinationPort;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowFilter model) {
            this.sourceAddress(model.sourceAddress);
            this.destinationAddress(model.destinationAddress);
            this.sourcePort(model.sourcePort);
            this.destinationPort(model.destinationPort);
            this.protocols(model.protocols);
        }

        public final Address.Builder getSourceAddress() {
            return this.sourceAddress != null ? this.sourceAddress.toBuilder() : null;
        }

        public final void setSourceAddress(Address.BuilderImpl sourceAddress) {
            this.sourceAddress = sourceAddress != null ? sourceAddress.build() : null;
        }

        @Override
        public final Builder sourceAddress(Address sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final Address.Builder getDestinationAddress() {
            return this.destinationAddress != null ? this.destinationAddress.toBuilder() : null;
        }

        public final void setDestinationAddress(Address.BuilderImpl destinationAddress) {
            this.destinationAddress = destinationAddress != null ? destinationAddress.build() : null;
        }

        @Override
        public final Builder destinationAddress(Address destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final String getSourcePort() {
            return this.sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolStringsCopier.copy(protocols);
        }

        @Override
        public final Builder protocols(Collection<String> protocols) {
            this.protocols = ProtocolStringsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(String ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public FlowFilter build() {
            return new FlowFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowFilter> {
        public Builder sourceAddress(Address var1);

        default public Builder sourceAddress(Consumer<Address.Builder> sourceAddress) {
            return this.sourceAddress((Address)((Address.Builder)Address.builder().applyMutation(sourceAddress)).build());
        }

        public Builder destinationAddress(Address var1);

        default public Builder destinationAddress(Consumer<Address.Builder> destinationAddress) {
            return this.destinationAddress((Address)((Address.Builder)Address.builder().applyMutation(destinationAddress)).build());
        }

        public Builder sourcePort(String var1);

        public Builder destinationPort(String var1);

        public Builder protocols(Collection<String> var1);

        public Builder protocols(String ... var1);
    }
}

