/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigDefaultRulePhaseActionsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigRuleGroup;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigRuleGroupSetCopier;
import software.amazon.awssdk.services.networkfirewall.model.Tag;
import software.amazon.awssdk.services.networkfirewall.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProxyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProxyConfiguration> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(ProxyConfiguration.getter(ProxyConfiguration::proxyConfigurationName)).setter(ProxyConfiguration.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(ProxyConfiguration.getter(ProxyConfiguration::proxyConfigurationArn)).setter(ProxyConfiguration.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProxyConfiguration.getter(ProxyConfiguration::description)).setter(ProxyConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ProxyConfiguration.getter(ProxyConfiguration::createTime)).setter(ProxyConfiguration.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTime").getter(ProxyConfiguration.getter(ProxyConfiguration::deleteTime)).setter(ProxyConfiguration.setter(Builder::deleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").build()}).build();
    private static final SdkField<List<ProxyConfigRuleGroup>> RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroups").getter(ProxyConfiguration.getter(ProxyConfiguration::ruleGroups)).setter(ProxyConfiguration.setter(Builder::ruleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyConfigRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProxyConfigDefaultRulePhaseActionsRequest> DEFAULT_RULE_PHASE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultRulePhaseActions").getter(ProxyConfiguration.getter(ProxyConfiguration::defaultRulePhaseActions)).setter(ProxyConfiguration.setter(Builder::defaultRulePhaseActions)).constructor(ProxyConfigDefaultRulePhaseActionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRulePhaseActions").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ProxyConfiguration.getter(ProxyConfiguration::tags)).setter(ProxyConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, DELETE_TIME_FIELD, RULE_GROUPS_FIELD, DEFAULT_RULE_PHASE_ACTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProxyConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;
    private final String description;
    private final Instant createTime;
    private final Instant deleteTime;
    private final List<ProxyConfigRuleGroup> ruleGroups;
    private final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;
    private final List<Tag> tags;

    private ProxyConfiguration(BuilderImpl builder) {
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.ruleGroups = builder.ruleGroups;
        this.defaultRulePhaseActions = builder.defaultRulePhaseActions;
        this.tags = builder.tags;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant deleteTime() {
        return this.deleteTime;
    }

    public final boolean hasRuleGroups() {
        return this.ruleGroups != null && !(this.ruleGroups instanceof SdkAutoConstructList);
    }

    public final List<ProxyConfigRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    public final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions() {
        return this.defaultRulePhaseActions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroups() ? this.ruleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRulePhaseActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration)obj;
        return Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.deleteTime(), other.deleteTime()) && this.hasRuleGroups() == other.hasRuleGroups() && Objects.equals(this.ruleGroups(), other.ruleGroups()) && Objects.equals(this.defaultRulePhaseActions(), other.defaultRulePhaseActions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("DeleteTime", (Object)this.deleteTime()).add("RuleGroups", this.hasRuleGroups() ? this.ruleGroups() : null).add("DefaultRulePhaseActions", (Object)this.defaultRulePhaseActions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DeleteTime": {
                return Optional.ofNullable(clazz.cast(this.deleteTime()));
            }
            case "RuleGroups": {
                return Optional.ofNullable(clazz.cast(this.ruleGroups()));
            }
            case "DefaultRulePhaseActions": {
                return Optional.ofNullable(clazz.cast(this.defaultRulePhaseActions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("DeleteTime", DELETE_TIME_FIELD);
        map.put("RuleGroups", RULE_GROUPS_FIELD);
        map.put("DefaultRulePhaseActions", DEFAULT_RULE_PHASE_ACTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfiguration, T> g) {
        return obj -> g.apply((ProxyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String proxyConfigurationName;
        private String proxyConfigurationArn;
        private String description;
        private Instant createTime;
        private Instant deleteTime;
        private List<ProxyConfigRuleGroup> ruleGroups = DefaultSdkAutoConstructList.getInstance();
        private ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration model) {
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
            this.description(model.description);
            this.createTime(model.createTime);
            this.deleteTime(model.deleteTime);
            this.ruleGroups(model.ruleGroups);
            this.defaultRulePhaseActions(model.defaultRulePhaseActions);
            this.tags(model.tags);
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getDeleteTime() {
            return this.deleteTime;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final List<ProxyConfigRuleGroup.Builder> getRuleGroups() {
            List<ProxyConfigRuleGroup.Builder> result = ProxyConfigRuleGroupSetCopier.copyToBuilder(this.ruleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroups(Collection<ProxyConfigRuleGroup.BuilderImpl> ruleGroups) {
            this.ruleGroups = ProxyConfigRuleGroupSetCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public final Builder ruleGroups(Collection<ProxyConfigRuleGroup> ruleGroups) {
            this.ruleGroups = ProxyConfigRuleGroupSetCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(ProxyConfigRuleGroup ... ruleGroups) {
            this.ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<ProxyConfigRuleGroup.Builder> ... ruleGroups) {
            this.ruleGroups(Stream.of(ruleGroups).map(c -> (ProxyConfigRuleGroup)((ProxyConfigRuleGroup.Builder)ProxyConfigRuleGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProxyConfigDefaultRulePhaseActionsRequest.Builder getDefaultRulePhaseActions() {
            return this.defaultRulePhaseActions != null ? this.defaultRulePhaseActions.toBuilder() : null;
        }

        public final void setDefaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.BuilderImpl defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions != null ? defaultRulePhaseActions.build() : null;
        }

        @Override
        public final Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder deleteTime(Instant var1);

        public Builder ruleGroups(Collection<ProxyConfigRuleGroup> var1);

        public Builder ruleGroups(ProxyConfigRuleGroup ... var1);

        public Builder ruleGroups(Consumer<ProxyConfigRuleGroup.Builder> ... var1);

        public Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest var1);

        default public Builder defaultRulePhaseActions(Consumer<ProxyConfigDefaultRulePhaseActionsRequest.Builder> defaultRulePhaseActions) {
            return this.defaultRulePhaseActions((ProxyConfigDefaultRulePhaseActionsRequest)((ProxyConfigDefaultRulePhaseActionsRequest.Builder)ProxyConfigDefaultRulePhaseActionsRequest.builder().applyMutation(defaultRulePhaseActions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

