/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.Attachment;
import software.amazon.awssdk.services.networkfirewall.model.PerObjectStatus;
import software.amazon.awssdk.services.networkfirewall.model.SyncStateConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyncState> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(SyncState.getter(SyncState::attachment)).setter(SyncState.setter(Builder::attachment)).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<Map<String, PerObjectStatus>> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Config").getter(SyncState.getter(SyncState::config)).setter(SyncState.setter(Builder::config)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerObjectStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SyncState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Attachment attachment;
    private final Map<String, PerObjectStatus> config;

    private SyncState(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.config = builder.config;
    }

    public final Attachment attachment() {
        return this.attachment;
    }

    public final boolean hasConfig() {
        return this.config != null && !(this.config instanceof SdkAutoConstructMap);
    }

    public final Map<String, PerObjectStatus> config() {
        return this.config;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfig() ? this.config() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncState)) {
            return false;
        }
        SyncState other = (SyncState)obj;
        return Objects.equals(this.attachment(), other.attachment()) && this.hasConfig() == other.hasConfig() && Objects.equals(this.config(), other.config());
    }

    public final String toString() {
        return ToString.builder((String)"SyncState").add("Attachment", (Object)this.attachment()).add("Config", this.hasConfig() ? this.config() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("Config", CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyncState, T> g) {
        return obj -> g.apply((SyncState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attachment attachment;
        private Map<String, PerObjectStatus> config = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SyncState model) {
            this.attachment(model.attachment);
            this.config(model.config);
        }

        public final Attachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final Map<String, PerObjectStatus.Builder> getConfig() {
            Map<String, PerObjectStatus.Builder> result = SyncStateConfigCopier.copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfig(Map<String, PerObjectStatus.BuilderImpl> config) {
            this.config = SyncStateConfigCopier.copyFromBuilder(config);
        }

        @Override
        public final Builder config(Map<String, PerObjectStatus> config) {
            this.config = SyncStateConfigCopier.copy(config);
            return this;
        }

        public SyncState build() {
            return new SyncState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyncState> {
        public Builder attachment(Attachment var1);

        default public Builder attachment(Consumer<Attachment.Builder> attachment) {
            return this.attachment((Attachment)((Attachment.Builder)Attachment.builder().applyMutation(attachment)).build());
        }

        public Builder config(Map<String, PerObjectStatus> var1);
    }
}

