/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.ProxyConfigDefaultRulePhaseActionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxyConfigurationRequest
extends NetworkFirewallRequest
implements ToCopyableBuilder<Builder, UpdateProxyConfigurationRequest> {
    private static final SdkField<String> PROXY_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationName").getter(UpdateProxyConfigurationRequest.getter(UpdateProxyConfigurationRequest::proxyConfigurationName)).setter(UpdateProxyConfigurationRequest.setter(Builder::proxyConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationName").build()}).build();
    private static final SdkField<String> PROXY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyConfigurationArn").getter(UpdateProxyConfigurationRequest.getter(UpdateProxyConfigurationRequest::proxyConfigurationArn)).setter(UpdateProxyConfigurationRequest.setter(Builder::proxyConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyConfigurationArn").build()}).build();
    private static final SdkField<ProxyConfigDefaultRulePhaseActionsRequest> DEFAULT_RULE_PHASE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultRulePhaseActions").getter(UpdateProxyConfigurationRequest.getter(UpdateProxyConfigurationRequest::defaultRulePhaseActions)).setter(UpdateProxyConfigurationRequest.setter(Builder::defaultRulePhaseActions)).constructor(ProxyConfigDefaultRulePhaseActionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRulePhaseActions").build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateProxyConfigurationRequest.getter(UpdateProxyConfigurationRequest::updateToken)).setter(UpdateProxyConfigurationRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_CONFIGURATION_NAME_FIELD, PROXY_CONFIGURATION_ARN_FIELD, DEFAULT_RULE_PHASE_ACTIONS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProxyConfigurationRequest.memberNameToFieldInitializer();
    private final String proxyConfigurationName;
    private final String proxyConfigurationArn;
    private final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;
    private final String updateToken;

    private UpdateProxyConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.proxyConfigurationName = builder.proxyConfigurationName;
        this.proxyConfigurationArn = builder.proxyConfigurationArn;
        this.defaultRulePhaseActions = builder.defaultRulePhaseActions;
        this.updateToken = builder.updateToken;
    }

    public final String proxyConfigurationName() {
        return this.proxyConfigurationName;
    }

    public final String proxyConfigurationArn() {
        return this.proxyConfigurationArn;
    }

    public final ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions() {
        return this.defaultRulePhaseActions;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRulePhaseActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyConfigurationRequest)) {
            return false;
        }
        UpdateProxyConfigurationRequest other = (UpdateProxyConfigurationRequest)((Object)obj);
        return Objects.equals(this.proxyConfigurationName(), other.proxyConfigurationName()) && Objects.equals(this.proxyConfigurationArn(), other.proxyConfigurationArn()) && Objects.equals(this.defaultRulePhaseActions(), other.defaultRulePhaseActions()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxyConfigurationRequest").add("ProxyConfigurationName", (Object)this.proxyConfigurationName()).add("ProxyConfigurationArn", (Object)this.proxyConfigurationArn()).add("DefaultRulePhaseActions", (Object)this.defaultRulePhaseActions()).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationName()));
            }
            case "ProxyConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.proxyConfigurationArn()));
            }
            case "DefaultRulePhaseActions": {
                return Optional.ofNullable(clazz.cast(this.defaultRulePhaseActions()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyConfigurationName", PROXY_CONFIGURATION_NAME_FIELD);
        map.put("ProxyConfigurationArn", PROXY_CONFIGURATION_ARN_FIELD);
        map.put("DefaultRulePhaseActions", DEFAULT_RULE_PHASE_ACTIONS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateProxyConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallRequest.BuilderImpl
    implements Builder {
        private String proxyConfigurationName;
        private String proxyConfigurationArn;
        private ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions;
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyConfigurationRequest model) {
            super(model);
            this.proxyConfigurationName(model.proxyConfigurationName);
            this.proxyConfigurationArn(model.proxyConfigurationArn);
            this.defaultRulePhaseActions(model.defaultRulePhaseActions);
            this.updateToken(model.updateToken);
        }

        public final String getProxyConfigurationName() {
            return this.proxyConfigurationName;
        }

        public final void setProxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
        }

        @Override
        public final Builder proxyConfigurationName(String proxyConfigurationName) {
            this.proxyConfigurationName = proxyConfigurationName;
            return this;
        }

        public final String getProxyConfigurationArn() {
            return this.proxyConfigurationArn;
        }

        public final void setProxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
        }

        @Override
        public final Builder proxyConfigurationArn(String proxyConfigurationArn) {
            this.proxyConfigurationArn = proxyConfigurationArn;
            return this;
        }

        public final ProxyConfigDefaultRulePhaseActionsRequest.Builder getDefaultRulePhaseActions() {
            return this.defaultRulePhaseActions != null ? this.defaultRulePhaseActions.toBuilder() : null;
        }

        public final void setDefaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest.BuilderImpl defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions != null ? defaultRulePhaseActions.build() : null;
        }

        @Override
        public final Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest defaultRulePhaseActions) {
            this.defaultRulePhaseActions = defaultRulePhaseActions;
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProxyConfigurationRequest build() {
            return new UpdateProxyConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxyConfigurationRequest> {
        public Builder proxyConfigurationName(String var1);

        public Builder proxyConfigurationArn(String var1);

        public Builder defaultRulePhaseActions(ProxyConfigDefaultRulePhaseActionsRequest var1);

        default public Builder defaultRulePhaseActions(Consumer<ProxyConfigDefaultRulePhaseActionsRequest.Builder> defaultRulePhaseActions) {
            return this.defaultRulePhaseActions((ProxyConfigDefaultRulePhaseActionsRequest)((ProxyConfigDefaultRulePhaseActionsRequest.Builder)ProxyConfigDefaultRulePhaseActionsRequest.builder().applyMutation(defaultRulePhaseActions)).build());
        }

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

