/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupPriorityResult;
import software.amazon.awssdk.services.networkfirewall.model.ProxyRuleGroupPriorityResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProxyRuleGroupPrioritiesResponse
extends NetworkFirewallResponse
implements ToCopyableBuilder<Builder, UpdateProxyRuleGroupPrioritiesResponse> {
    private static final SdkField<List<ProxyRuleGroupPriorityResult>> PROXY_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProxyRuleGroups").getter(UpdateProxyRuleGroupPrioritiesResponse.getter(UpdateProxyRuleGroupPrioritiesResponse::proxyRuleGroups)).setter(UpdateProxyRuleGroupPrioritiesResponse.setter(Builder::proxyRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProxyRuleGroupPriorityResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateToken").getter(UpdateProxyRuleGroupPrioritiesResponse.getter(UpdateProxyRuleGroupPrioritiesResponse::updateToken)).setter(UpdateProxyRuleGroupPrioritiesResponse.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_RULE_GROUPS_FIELD, UPDATE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProxyRuleGroupPrioritiesResponse.memberNameToFieldInitializer();
    private final List<ProxyRuleGroupPriorityResult> proxyRuleGroups;
    private final String updateToken;

    private UpdateProxyRuleGroupPrioritiesResponse(BuilderImpl builder) {
        super(builder);
        this.proxyRuleGroups = builder.proxyRuleGroups;
        this.updateToken = builder.updateToken;
    }

    public final boolean hasProxyRuleGroups() {
        return this.proxyRuleGroups != null && !(this.proxyRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<ProxyRuleGroupPriorityResult> proxyRuleGroups() {
        return this.proxyRuleGroups;
    }

    public final String updateToken() {
        return this.updateToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProxyRuleGroups() ? this.proxyRuleGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxyRuleGroupPrioritiesResponse)) {
            return false;
        }
        UpdateProxyRuleGroupPrioritiesResponse other = (UpdateProxyRuleGroupPrioritiesResponse)((Object)obj);
        return this.hasProxyRuleGroups() == other.hasProxyRuleGroups() && Objects.equals(this.proxyRuleGroups(), other.proxyRuleGroups()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProxyRuleGroupPrioritiesResponse").add("ProxyRuleGroups", this.hasProxyRuleGroups() ? this.proxyRuleGroups() : null).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProxyRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.proxyRuleGroups()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProxyRuleGroups", PROXY_RULE_GROUPS_FIELD);
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProxyRuleGroupPrioritiesResponse, T> g) {
        return obj -> g.apply((UpdateProxyRuleGroupPrioritiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkFirewallResponse.BuilderImpl
    implements Builder {
        private List<ProxyRuleGroupPriorityResult> proxyRuleGroups = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProxyRuleGroupPrioritiesResponse model) {
            super(model);
            this.proxyRuleGroups(model.proxyRuleGroups);
            this.updateToken(model.updateToken);
        }

        public final List<ProxyRuleGroupPriorityResult.Builder> getProxyRuleGroups() {
            List<ProxyRuleGroupPriorityResult.Builder> result = ProxyRuleGroupPriorityResultListCopier.copyToBuilder(this.proxyRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProxyRuleGroups(Collection<ProxyRuleGroupPriorityResult.BuilderImpl> proxyRuleGroups) {
            this.proxyRuleGroups = ProxyRuleGroupPriorityResultListCopier.copyFromBuilder(proxyRuleGroups);
        }

        @Override
        public final Builder proxyRuleGroups(Collection<ProxyRuleGroupPriorityResult> proxyRuleGroups) {
            this.proxyRuleGroups = ProxyRuleGroupPriorityResultListCopier.copy(proxyRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyRuleGroups(ProxyRuleGroupPriorityResult ... proxyRuleGroups) {
            this.proxyRuleGroups(Arrays.asList(proxyRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proxyRuleGroups(Consumer<ProxyRuleGroupPriorityResult.Builder> ... proxyRuleGroups) {
            this.proxyRuleGroups(Stream.of(proxyRuleGroups).map(c -> (ProxyRuleGroupPriorityResult)((ProxyRuleGroupPriorityResult.Builder)ProxyRuleGroupPriorityResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        @Override
        public UpdateProxyRuleGroupPrioritiesResponse build() {
            return new UpdateProxyRuleGroupPrioritiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkFirewallResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProxyRuleGroupPrioritiesResponse> {
        public Builder proxyRuleGroups(Collection<ProxyRuleGroupPriorityResult> var1);

        public Builder proxyRuleGroups(ProxyRuleGroupPriorityResult ... var1);

        public Builder proxyRuleGroups(Consumer<ProxyRuleGroupPriorityResult.Builder> ... var1);

        public Builder updateToken(String var1);
    }
}

