/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.FirewallMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;

public class ListFirewallsIterable
implements SdkIterable<ListFirewallsResponse> {
    private final NetworkFirewallClient client;
    private final ListFirewallsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallsIterable(NetworkFirewallClient client, ListFirewallsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFirewallsResponseFetcher();
    }

    public Iterator<ListFirewallsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallMetadata> firewalls() {
        Function<ListFirewallsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewalls() != null) {
                return response.firewalls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallsResponseFetcher
    implements SyncPageFetcher<ListFirewallsResponse> {
        private ListFirewallsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallsResponse nextPage(ListFirewallsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallsIterable.this.client.listFirewalls(ListFirewallsIterable.this.firstRequest);
            }
            return ListFirewallsIterable.this.client.listFirewalls((ListFirewallsRequest)((Object)ListFirewallsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

