/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkfirewall.NetworkFirewallAsyncClient;
import software.amazon.awssdk.services.networkfirewall.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse;

public class ListFlowOperationsPublisher
implements SdkPublisher<ListFlowOperationsResponse> {
    private final NetworkFirewallAsyncClient client;
    private final ListFlowOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowOperationsPublisher(NetworkFirewallAsyncClient client, ListFlowOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowOperationsPublisher(NetworkFirewallAsyncClient client, ListFlowOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowOperationMetadata> flowOperations() {
        Function<ListFlowOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowOperations() != null) {
                return response.flowOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowOperationsResponseFetcher
    implements AsyncPageFetcher<ListFlowOperationsResponse> {
        private ListFlowOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowOperationsResponse> nextPage(ListFlowOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowOperationsPublisher.this.client.listFlowOperations(ListFlowOperationsPublisher.this.firstRequest);
            }
            return ListFlowOperationsPublisher.this.client.listFlowOperations((ListFlowOperationsRequest)((Object)ListFlowOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

