/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.Attachment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGatewayAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectConnectGatewayAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::attachment)).setter(DirectConnectGatewayAttachment.setter(Builder::attachment)).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectConnectGatewayArn").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::directConnectGatewayArn)).setter(DirectConnectGatewayAttachment.setter(Builder::directConnectGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectConnectGatewayArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, DIRECT_CONNECT_GATEWAY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectConnectGatewayAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Attachment attachment;
    private final String directConnectGatewayArn;

    private DirectConnectGatewayAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.directConnectGatewayArn = builder.directConnectGatewayArn;
    }

    public final Attachment attachment() {
        return this.attachment;
    }

    public final String directConnectGatewayArn() {
        return this.directConnectGatewayArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAttachment)) {
            return false;
        }
        DirectConnectGatewayAttachment other = (DirectConnectGatewayAttachment)obj;
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.directConnectGatewayArn(), other.directConnectGatewayArn());
    }

    public final String toString() {
        return ToString.builder((String)"DirectConnectGatewayAttachment").add("Attachment", (Object)this.attachment()).add("DirectConnectGatewayArn", (Object)this.directConnectGatewayArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "DirectConnectGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("DirectConnectGatewayArn", DIRECT_CONNECT_GATEWAY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAttachment, T> g) {
        return obj -> g.apply((DirectConnectGatewayAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attachment attachment;
        private String directConnectGatewayArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAttachment model) {
            this.attachment(model.attachment);
            this.directConnectGatewayArn(model.directConnectGatewayArn);
        }

        public final Attachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getDirectConnectGatewayArn() {
            return this.directConnectGatewayArn;
        }

        public final void setDirectConnectGatewayArn(String directConnectGatewayArn) {
            this.directConnectGatewayArn = directConnectGatewayArn;
        }

        @Override
        public final Builder directConnectGatewayArn(String directConnectGatewayArn) {
            this.directConnectGatewayArn = directConnectGatewayArn;
            return this;
        }

        public DirectConnectGatewayAttachment build() {
            return new DirectConnectGatewayAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectConnectGatewayAttachment> {
        public Builder attachment(Attachment var1);

        default public Builder attachment(Consumer<Attachment.Builder> attachment) {
            return this.attachment((Attachment)((Attachment.Builder)Attachment.builder().applyMutation(attachment)).build());
        }

        public Builder directConnectGatewayArn(String var1);
    }
}

