/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.EdgeSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeOverride> {
    private static final SdkField<List<List<String>>> EDGE_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeSets").getter(EdgeOverride.getter(EdgeOverride::edgeSets)).setter(EdgeOverride.setter(Builder::edgeSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> USE_EDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseEdge").getter(EdgeOverride.getter(EdgeOverride::useEdge)).setter(EdgeOverride.setter(Builder::useEdge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseEdge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_SETS_FIELD, USE_EDGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EdgeOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<List<String>> edgeSets;
    private final String useEdge;

    private EdgeOverride(BuilderImpl builder) {
        this.edgeSets = builder.edgeSets;
        this.useEdge = builder.useEdge;
    }

    public final boolean hasEdgeSets() {
        return this.edgeSets != null && !(this.edgeSets instanceof SdkAutoConstructList);
    }

    public final List<List<String>> edgeSets() {
        return this.edgeSets;
    }

    public final String useEdge() {
        return this.useEdge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeSets() ? this.edgeSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useEdge());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeOverride)) {
            return false;
        }
        EdgeOverride other = (EdgeOverride)obj;
        return this.hasEdgeSets() == other.hasEdgeSets() && Objects.equals(this.edgeSets(), other.edgeSets()) && Objects.equals(this.useEdge(), other.useEdge());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeOverride").add("EdgeSets", this.hasEdgeSets() ? this.edgeSets() : null).add("UseEdge", (Object)this.useEdge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeSets": {
                return Optional.ofNullable(clazz.cast(this.edgeSets()));
            }
            case "UseEdge": {
                return Optional.ofNullable(clazz.cast(this.useEdge()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EdgeSets", EDGE_SETS_FIELD);
        map.put("UseEdge", USE_EDGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeOverride, T> g) {
        return obj -> g.apply((EdgeOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<String>> edgeSets = DefaultSdkAutoConstructList.getInstance();
        private String useEdge;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeOverride model) {
            this.edgeSets(model.edgeSets);
            this.useEdge(model.useEdge);
        }

        public final Collection<? extends Collection<String>> getEdgeSets() {
            if (this.edgeSets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeSets;
        }

        public final void setEdgeSets(Collection<? extends Collection<String>> edgeSets) {
            this.edgeSets = EdgeSetListCopier.copy(edgeSets);
        }

        @Override
        public final Builder edgeSets(Collection<? extends Collection<String>> edgeSets) {
            this.edgeSets = EdgeSetListCopier.copy(edgeSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeSets(Collection<String> ... edgeSets) {
            this.edgeSets((Collection<? extends Collection<String>>)Arrays.asList(edgeSets));
            return this;
        }

        public final String getUseEdge() {
            return this.useEdge;
        }

        public final void setUseEdge(String useEdge) {
            this.useEdge = useEdge;
        }

        @Override
        public final Builder useEdge(String useEdge) {
            this.useEdge = useEdge;
            return this;
        }

        public EdgeOverride build() {
            return new EdgeOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeOverride> {
        public Builder edgeSets(Collection<? extends Collection<String>> var1);

        public Builder edgeSets(Collection<String> ... var1);

        public Builder useEdge(String var1);
    }
}

