/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcOptions> {
    private static final SdkField<Boolean> IPV6_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Support").getter(VpcOptions.getter(VpcOptions::ipv6Support)).setter(VpcOptions.setter(Builder::ipv6Support)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Support").build()}).build();
    private static final SdkField<Boolean> APPLIANCE_MODE_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplianceModeSupport").getter(VpcOptions.getter(VpcOptions::applianceModeSupport)).setter(VpcOptions.setter(Builder::applianceModeSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplianceModeSupport").build()}).build();
    private static final SdkField<Boolean> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DnsSupport").getter(VpcOptions.getter(VpcOptions::dnsSupport)).setter(VpcOptions.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").build()}).build();
    private static final SdkField<Boolean> SECURITY_GROUP_REFERENCING_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SecurityGroupReferencingSupport").getter(VpcOptions.getter(VpcOptions::securityGroupReferencingSupport)).setter(VpcOptions.setter(Builder::securityGroupReferencingSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferencingSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_SUPPORT_FIELD, APPLIANCE_MODE_SUPPORT_FIELD, DNS_SUPPORT_FIELD, SECURITY_GROUP_REFERENCING_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean ipv6Support;
    private final Boolean applianceModeSupport;
    private final Boolean dnsSupport;
    private final Boolean securityGroupReferencingSupport;

    private VpcOptions(BuilderImpl builder) {
        this.ipv6Support = builder.ipv6Support;
        this.applianceModeSupport = builder.applianceModeSupport;
        this.dnsSupport = builder.dnsSupport;
        this.securityGroupReferencingSupport = builder.securityGroupReferencingSupport;
    }

    public final Boolean ipv6Support() {
        return this.ipv6Support;
    }

    public final Boolean applianceModeSupport() {
        return this.applianceModeSupport;
    }

    public final Boolean dnsSupport() {
        return this.dnsSupport;
    }

    public final Boolean securityGroupReferencingSupport() {
        return this.securityGroupReferencingSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Support());
        hashCode = 31 * hashCode + Objects.hashCode(this.applianceModeSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupReferencingSupport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOptions)) {
            return false;
        }
        VpcOptions other = (VpcOptions)obj;
        return Objects.equals(this.ipv6Support(), other.ipv6Support()) && Objects.equals(this.applianceModeSupport(), other.applianceModeSupport()) && Objects.equals(this.dnsSupport(), other.dnsSupport()) && Objects.equals(this.securityGroupReferencingSupport(), other.securityGroupReferencingSupport());
    }

    public final String toString() {
        return ToString.builder((String)"VpcOptions").add("Ipv6Support", (Object)this.ipv6Support()).add("ApplianceModeSupport", (Object)this.applianceModeSupport()).add("DnsSupport", (Object)this.dnsSupport()).add("SecurityGroupReferencingSupport", (Object)this.securityGroupReferencingSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6Support": {
                return Optional.ofNullable(clazz.cast(this.ipv6Support()));
            }
            case "ApplianceModeSupport": {
                return Optional.ofNullable(clazz.cast(this.applianceModeSupport()));
            }
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupport()));
            }
            case "SecurityGroupReferencingSupport": {
                return Optional.ofNullable(clazz.cast(this.securityGroupReferencingSupport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("Ipv6Support", IPV6_SUPPORT_FIELD);
        map.put("ApplianceModeSupport", APPLIANCE_MODE_SUPPORT_FIELD);
        map.put("DnsSupport", DNS_SUPPORT_FIELD);
        map.put("SecurityGroupReferencingSupport", SECURITY_GROUP_REFERENCING_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOptions, T> g) {
        return obj -> g.apply((VpcOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean ipv6Support;
        private Boolean applianceModeSupport;
        private Boolean dnsSupport;
        private Boolean securityGroupReferencingSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOptions model) {
            this.ipv6Support(model.ipv6Support);
            this.applianceModeSupport(model.applianceModeSupport);
            this.dnsSupport(model.dnsSupport);
            this.securityGroupReferencingSupport(model.securityGroupReferencingSupport);
        }

        public final Boolean getIpv6Support() {
            return this.ipv6Support;
        }

        public final void setIpv6Support(Boolean ipv6Support) {
            this.ipv6Support = ipv6Support;
        }

        @Override
        public final Builder ipv6Support(Boolean ipv6Support) {
            this.ipv6Support = ipv6Support;
            return this;
        }

        public final Boolean getApplianceModeSupport() {
            return this.applianceModeSupport;
        }

        public final void setApplianceModeSupport(Boolean applianceModeSupport) {
            this.applianceModeSupport = applianceModeSupport;
        }

        @Override
        public final Builder applianceModeSupport(Boolean applianceModeSupport) {
            this.applianceModeSupport = applianceModeSupport;
            return this;
        }

        public final Boolean getDnsSupport() {
            return this.dnsSupport;
        }

        public final void setDnsSupport(Boolean dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(Boolean dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        public final Boolean getSecurityGroupReferencingSupport() {
            return this.securityGroupReferencingSupport;
        }

        public final void setSecurityGroupReferencingSupport(Boolean securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
        }

        @Override
        public final Builder securityGroupReferencingSupport(Boolean securityGroupReferencingSupport) {
            this.securityGroupReferencingSupport = securityGroupReferencingSupport;
            return this;
        }

        public VpcOptions build() {
            return new VpcOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcOptions> {
        public Builder ipv6Support(Boolean var1);

        public Builder applianceModeSupport(Boolean var1);

        public Builder dnsSupport(Boolean var1);

        public Builder securityGroupReferencingSupport(Boolean var1);
    }
}

