/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeEventsResponse;

public class GetCoreNetworkChangeEventsIterable
implements SdkIterable<GetCoreNetworkChangeEventsResponse> {
    private final NetworkManagerClient client;
    private final GetCoreNetworkChangeEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCoreNetworkChangeEventsIterable(NetworkManagerClient client, GetCoreNetworkChangeEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCoreNetworkChangeEventsResponseFetcher();
    }

    public Iterator<GetCoreNetworkChangeEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoreNetworkChangeEvent> coreNetworkChangeEvents() {
        Function<GetCoreNetworkChangeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkChangeEvents() != null) {
                return response.coreNetworkChangeEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCoreNetworkChangeEventsResponseFetcher
    implements SyncPageFetcher<GetCoreNetworkChangeEventsResponse> {
        private GetCoreNetworkChangeEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetCoreNetworkChangeEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCoreNetworkChangeEventsResponse nextPage(GetCoreNetworkChangeEventsResponse previousPage) {
            if (previousPage == null) {
                return GetCoreNetworkChangeEventsIterable.this.client.getCoreNetworkChangeEvents(GetCoreNetworkChangeEventsIterable.this.firstRequest);
            }
            return GetCoreNetworkChangeEventsIterable.this.client.getCoreNetworkChangeEvents((GetCoreNetworkChangeEventsRequest)((Object)GetCoreNetworkChangeEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

