/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmonitor.model.MonitorState;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMonitorResponse
extends NetworkMonitorResponse
implements ToCopyableBuilder<Builder, CreateMonitorResponse> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorArn").getter(CreateMonitorResponse.getter(CreateMonitorResponse::monitorArn)).setter(CreateMonitorResponse.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorArn").build()}).build();
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(CreateMonitorResponse.getter(CreateMonitorResponse::monitorName)).setter(CreateMonitorResponse.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CreateMonitorResponse.getter(CreateMonitorResponse::stateAsString)).setter(CreateMonitorResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Long> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("aggregationPeriod").getter(CreateMonitorResponse.getter(CreateMonitorResponse::aggregationPeriod)).setter(CreateMonitorResponse.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationPeriod").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMonitorResponse.getter(CreateMonitorResponse::tags)).setter(CreateMonitorResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD, MONITOR_NAME_FIELD, STATE_FIELD, AGGREGATION_PERIOD_FIELD, TAGS_FIELD));
    private final String monitorArn;
    private final String monitorName;
    private final String state;
    private final Long aggregationPeriod;
    private final Map<String, String> tags;

    private CreateMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.monitorName = builder.monitorName;
        this.state = builder.state;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.tags = builder.tags;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final MonitorState state() {
        return MonitorState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Long aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorResponse)) {
            return false;
        }
        CreateMonitorResponse other = (CreateMonitorResponse)((Object)obj);
        return Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMonitorResponse").add("MonitorArn", (Object)this.monitorArn()).add("MonitorName", (Object)this.monitorName()).add("State", (Object)this.stateAsString()).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "aggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorResponse, T> g) {
        return obj -> g.apply((CreateMonitorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkMonitorResponse.BuilderImpl
    implements Builder {
        private String monitorArn;
        private String monitorName;
        private String state;
        private Long aggregationPeriod;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorResponse model) {
            super(model);
            this.monitorArn(model.monitorArn);
            this.monitorName(model.monitorName);
            this.state(model.state);
            this.aggregationPeriod(model.aggregationPeriod);
            this.tags(model.tags);
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MonitorState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Long getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateMonitorResponse build() {
            return new CreateMonitorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkMonitorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMonitorResponse> {
        public Builder monitorArn(String var1);

        public Builder monitorName(String var1);

        public Builder state(String var1);

        public Builder state(MonitorState var1);

        public Builder aggregationPeriod(Long var1);

        public Builder tags(Map<String, String> var1);
    }
}

