/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.oam.model.ResourceTypesOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAttachedLinksItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListAttachedLinksItem> {
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(ListAttachedLinksItem.getter(ListAttachedLinksItem::label)).setter(ListAttachedLinksItem.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> LINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkArn").getter(ListAttachedLinksItem.getter(ListAttachedLinksItem::linkArn)).setter(ListAttachedLinksItem.setter(Builder::linkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkArn").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(ListAttachedLinksItem.getter(ListAttachedLinksItem::resourceTypes)).setter(ListAttachedLinksItem.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, LINK_ARN_FIELD, RESOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAttachedLinksItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String label;
    private final String linkArn;
    private final List<String> resourceTypes;

    private ListAttachedLinksItem(BuilderImpl builder) {
        this.label = builder.label;
        this.linkArn = builder.linkArn;
        this.resourceTypes = builder.resourceTypes;
    }

    public final String label() {
        return this.label;
    }

    public final String linkArn() {
        return this.linkArn;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedLinksItem)) {
            return false;
        }
        ListAttachedLinksItem other = (ListAttachedLinksItem)obj;
        return Objects.equals(this.label(), other.label()) && Objects.equals(this.linkArn(), other.linkArn()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"ListAttachedLinksItem").add("Label", (Object)this.label()).add("LinkArn", (Object)this.linkArn()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "LinkArn": {
                return Optional.ofNullable(clazz.cast(this.linkArn()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Label", LABEL_FIELD);
        map.put("LinkArn", LINK_ARN_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedLinksItem, T> g) {
        return obj -> g.apply((ListAttachedLinksItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String label;
        private String linkArn;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedLinksItem model) {
            this.label(model.label);
            this.linkArn(model.linkArn);
            this.resourceTypes(model.resourceTypes);
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getLinkArn() {
            return this.linkArn;
        }

        public final void setLinkArn(String linkArn) {
            this.linkArn = linkArn;
        }

        @Override
        public final Builder linkArn(String linkArn) {
            this.linkArn = linkArn;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesOutputCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public ListAttachedLinksItem build() {
            return new ListAttachedLinksItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListAttachedLinksItem> {
        public Builder label(String var1);

        public Builder linkArn(String var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);
    }
}

