/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateShareRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateShareRequest.Builder, CreateShareRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(CreateShareRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> PRINCIPAL_SUBSCRIBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalSubscriber").getter(getter(CreateShareRequest::principalSubscriber))
            .setter(setter(Builder::principalSubscriber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalSubscriber").build())
            .build();

    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareName").getter(getter(CreateShareRequest::shareName)).setter(setter(Builder::shareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            PRINCIPAL_SUBSCRIBER_FIELD, SHARE_NAME_FIELD));

    private final String resourceArn;

    private final String principalSubscriber;

    private final String shareName;

    private CreateShareRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.principalSubscriber = builder.principalSubscriber;
        this.shareName = builder.shareName;
    }

    /**
     * <p>
     * The resource ARN for the analytics store to be shared.
     * </p>
     * 
     * @return The resource ARN for the analytics store to be shared.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The principal subscriber is the account being given access to the analytics store data through the share offer.
     * </p>
     * 
     * @return The principal subscriber is the account being given access to the analytics store data through the share
     *         offer.
     */
    public final String principalSubscriber() {
        return principalSubscriber;
    }

    /**
     * <p>
     * A name given to the share.
     * </p>
     * 
     * @return A name given to the share.
     */
    public final String shareName() {
        return shareName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(shareName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateShareRequest)) {
            return false;
        }
        CreateShareRequest other = (CreateShareRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(principalSubscriber(), other.principalSubscriber())
                && Objects.equals(shareName(), other.shareName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateShareRequest").add("ResourceArn", resourceArn())
                .add("PrincipalSubscriber", principalSubscriber()).add("ShareName", shareName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "principalSubscriber":
            return Optional.ofNullable(clazz.cast(principalSubscriber()));
        case "shareName":
            return Optional.ofNullable(clazz.cast(shareName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateShareRequest, T> g) {
        return obj -> g.apply((CreateShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateShareRequest> {
        /**
         * <p>
         * The resource ARN for the analytics store to be shared.
         * </p>
         * 
         * @param resourceArn
         *        The resource ARN for the analytics store to be shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The principal subscriber is the account being given access to the analytics store data through the share
         * offer.
         * </p>
         * 
         * @param principalSubscriber
         *        The principal subscriber is the account being given access to the analytics store data through the
         *        share offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalSubscriber(String principalSubscriber);

        /**
         * <p>
         * A name given to the share.
         * </p>
         * 
         * @param shareName
         *        A name given to the share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareName(String shareName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String principalSubscriber;

        private String shareName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateShareRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            principalSubscriber(model.principalSubscriber);
            shareName(model.shareName);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPrincipalSubscriber() {
            return principalSubscriber;
        }

        public final void setPrincipalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
        }

        @Override
        public final Builder principalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
            return this;
        }

        public final String getShareName() {
            return shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateShareRequest build() {
            return new CreateShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
