/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunTaskResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetRunTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(GetRunTaskResponse.getter(GetRunTaskResponse::taskId)).setter(GetRunTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetRunTaskResponse.getter(GetRunTaskResponse::statusAsString)).setter(GetRunTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRunTaskResponse.getter(GetRunTaskResponse::name)).setter(GetRunTaskResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpus").getter(GetRunTaskResponse.getter(GetRunTaskResponse::cpus)).setter(GetRunTaskResponse.setter(Builder::cpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(GetRunTaskResponse.getter(GetRunTaskResponse::memory)).setter(GetRunTaskResponse.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRunTaskResponse.getter(GetRunTaskResponse::creationTime)).setter(GetRunTaskResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetRunTaskResponse.getter(GetRunTaskResponse::startTime)).setter(GetRunTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopTime").getter(GetRunTaskResponse.getter(GetRunTaskResponse::stopTime)).setter(GetRunTaskResponse.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetRunTaskResponse.getter(GetRunTaskResponse::statusMessage)).setter(GetRunTaskResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStream").getter(GetRunTaskResponse.getter(GetRunTaskResponse::logStream)).setter(GetRunTaskResponse.setter(Builder::logStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStream").build()}).build();
    private static final SdkField<Integer> GPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gpus").getter(GetRunTaskResponse.getter(GetRunTaskResponse::gpus)).setter(GetRunTaskResponse.setter(Builder::gpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpus").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(GetRunTaskResponse.getter(GetRunTaskResponse::instanceType)).setter(GetRunTaskResponse.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetRunTaskResponse.getter(GetRunTaskResponse::failureReason)).setter(GetRunTaskResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, STATUS_FIELD, NAME_FIELD, CPUS_FIELD, MEMORY_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, STOP_TIME_FIELD, STATUS_MESSAGE_FIELD, LOG_STREAM_FIELD, GPUS_FIELD, INSTANCE_TYPE_FIELD, FAILURE_REASON_FIELD));
    private final String taskId;
    private final String status;
    private final String name;
    private final Integer cpus;
    private final Integer memory;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant stopTime;
    private final String statusMessage;
    private final String logStream;
    private final Integer gpus;
    private final String instanceType;
    private final String failureReason;

    private GetRunTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.name = builder.name;
        this.cpus = builder.cpus;
        this.memory = builder.memory;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.statusMessage = builder.statusMessage;
        this.logStream = builder.logStream;
        this.gpus = builder.gpus;
        this.instanceType = builder.instanceType;
        this.failureReason = builder.failureReason;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskStatus status() {
        return TaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final Integer cpus() {
        return this.cpus;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String logStream() {
        return this.logStream;
    }

    public final Integer gpus() {
        return this.gpus;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunTaskResponse)) {
            return false;
        }
        GetRunTaskResponse other = (GetRunTaskResponse)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.cpus(), other.cpus()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.logStream(), other.logStream()) && Objects.equals(this.gpus(), other.gpus()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunTaskResponse").add("TaskId", (Object)this.taskId()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("Cpus", (Object)this.cpus()).add("Memory", (Object)this.memory()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).add("StatusMessage", (Object)this.statusMessage()).add("LogStream", (Object)this.logStream()).add("Gpus", (Object)this.gpus()).add("InstanceType", (Object)this.instanceType()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "cpus": {
                return Optional.ofNullable(clazz.cast(this.cpus()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "logStream": {
                return Optional.ofNullable(clazz.cast(this.logStream()));
            }
            case "gpus": {
                return Optional.ofNullable(clazz.cast(this.gpus()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunTaskResponse, T> g) {
        return obj -> g.apply((GetRunTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String taskId;
        private String status;
        private String name;
        private Integer cpus;
        private Integer memory;
        private Instant creationTime;
        private Instant startTime;
        private Instant stopTime;
        private String statusMessage;
        private String logStream;
        private Integer gpus;
        private String instanceType;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunTaskResponse model) {
            super(model);
            this.taskId(model.taskId);
            this.status(model.status);
            this.name(model.name);
            this.cpus(model.cpus);
            this.memory(model.memory);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
            this.statusMessage(model.statusMessage);
            this.logStream(model.logStream);
            this.gpus(model.gpus);
            this.instanceType(model.instanceType);
            this.failureReason(model.failureReason);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getCpus() {
            return this.cpus;
        }

        public final void setCpus(Integer cpus) {
            this.cpus = cpus;
        }

        @Override
        public final Builder cpus(Integer cpus) {
            this.cpus = cpus;
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final Integer getGpus() {
            return this.gpus;
        }

        public final void setGpus(Integer gpus) {
            this.gpus = gpus;
        }

        @Override
        public final Builder gpus(Integer gpus) {
            this.gpus = gpus;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public GetRunTaskResponse build() {
            return new GetRunTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunTaskResponse> {
        public Builder taskId(String var1);

        public Builder status(String var1);

        public Builder status(TaskStatus var1);

        public Builder name(String var1);

        public Builder cpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);

        public Builder statusMessage(String var1);

        public Builder logStream(String var1);

        public Builder gpus(Integer var1);

        public Builder instanceType(String var1);

        public Builder failureReason(String var1);
    }
}

