/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.SequenceStoreDetail;

public class ListSequenceStoresPublisher
implements SdkPublisher<ListSequenceStoresResponse> {
    private final OmicsAsyncClient client;
    private final ListSequenceStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSequenceStoresPublisher(OmicsAsyncClient client, ListSequenceStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSequenceStoresPublisher(OmicsAsyncClient client, ListSequenceStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSequenceStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSequenceStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SequenceStoreDetail> sequenceStores() {
        Function<ListSequenceStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.sequenceStores() != null) {
                return response.sequenceStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSequenceStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSequenceStoresResponseFetcher
    implements AsyncPageFetcher<ListSequenceStoresResponse> {
        private ListSequenceStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListSequenceStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSequenceStoresResponse> nextPage(ListSequenceStoresResponse previousPage) {
            if (previousPage == null) {
                return ListSequenceStoresPublisher.this.client.listSequenceStores(ListSequenceStoresPublisher.this.firstRequest);
            }
            return ListSequenceStoresPublisher.this.client.listSequenceStores((ListSequenceStoresRequest)((Object)ListSequenceStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

