/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.FileType;
import software.amazon.awssdk.services.omics.model.ReadSetImportJobItemStatus;
import software.amazon.awssdk.services.omics.model.SourceFiles;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportReadSetSourceItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportReadSetSourceItem> {
    private static final SdkField<SourceFiles> SOURCE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceFiles").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::sourceFiles)).setter(ImportReadSetSourceItem.setter(Builder::sourceFiles)).constructor(SourceFiles::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFiles").build()}).build();
    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFileType").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::sourceFileTypeAsString)).setter(ImportReadSetSourceItem.setter(Builder::sourceFileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::statusAsString)).setter(ImportReadSetSourceItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::statusMessage)).setter(ImportReadSetSourceItem.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subjectId").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::subjectId)).setter(ImportReadSetSourceItem.setter(Builder::subjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()}).build();
    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleId").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::sampleId)).setter(ImportReadSetSourceItem.setter(Builder::sampleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()}).build();
    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedFrom").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::generatedFrom)).setter(ImportReadSetSourceItem.setter(Builder::generatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()}).build();
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceArn").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::referenceArn)).setter(ImportReadSetSourceItem.setter(Builder::referenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::name)).setter(ImportReadSetSourceItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::description)).setter(ImportReadSetSourceItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::tags)).setter(ImportReadSetSourceItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> READ_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readSetId").getter(ImportReadSetSourceItem.getter(ImportReadSetSourceItem::readSetId)).setter(ImportReadSetSourceItem.setter(Builder::readSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILES_FIELD, SOURCE_FILE_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, GENERATED_FROM_FIELD, REFERENCE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, READ_SET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportReadSetSourceItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SourceFiles sourceFiles;
    private final String sourceFileType;
    private final String status;
    private final String statusMessage;
    private final String subjectId;
    private final String sampleId;
    private final String generatedFrom;
    private final String referenceArn;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final String readSetId;

    private ImportReadSetSourceItem(BuilderImpl builder) {
        this.sourceFiles = builder.sourceFiles;
        this.sourceFileType = builder.sourceFileType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.generatedFrom = builder.generatedFrom;
        this.referenceArn = builder.referenceArn;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.readSetId = builder.readSetId;
    }

    public final SourceFiles sourceFiles() {
        return this.sourceFiles;
    }

    public final FileType sourceFileType() {
        return FileType.fromValue(this.sourceFileType);
    }

    public final String sourceFileTypeAsString() {
        return this.sourceFileType;
    }

    public final ReadSetImportJobItemStatus status() {
        return ReadSetImportJobItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String subjectId() {
        return this.subjectId;
    }

    public final String sampleId() {
        return this.sampleId;
    }

    public final String generatedFrom() {
        return this.generatedFrom;
    }

    public final String referenceArn() {
        return this.referenceArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String readSetId() {
        return this.readSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readSetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportReadSetSourceItem)) {
            return false;
        }
        ImportReadSetSourceItem other = (ImportReadSetSourceItem)obj;
        return Objects.equals(this.sourceFiles(), other.sourceFiles()) && Objects.equals(this.sourceFileTypeAsString(), other.sourceFileTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.subjectId(), other.subjectId()) && Objects.equals(this.sampleId(), other.sampleId()) && Objects.equals(this.generatedFrom(), other.generatedFrom()) && Objects.equals(this.referenceArn(), other.referenceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.readSetId(), other.readSetId());
    }

    public final String toString() {
        return ToString.builder((String)"ImportReadSetSourceItem").add("SourceFiles", (Object)this.sourceFiles()).add("SourceFileType", (Object)this.sourceFileTypeAsString()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("SubjectId", (Object)this.subjectId()).add("SampleId", (Object)this.sampleId()).add("GeneratedFrom", (Object)this.generatedFrom()).add("ReferenceArn", (Object)this.referenceArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("ReadSetId", (Object)this.readSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceFiles": {
                return Optional.ofNullable(clazz.cast(this.sourceFiles()));
            }
            case "sourceFileType": {
                return Optional.ofNullable(clazz.cast(this.sourceFileTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "subjectId": {
                return Optional.ofNullable(clazz.cast(this.subjectId()));
            }
            case "sampleId": {
                return Optional.ofNullable(clazz.cast(this.sampleId()));
            }
            case "generatedFrom": {
                return Optional.ofNullable(clazz.cast(this.generatedFrom()));
            }
            case "referenceArn": {
                return Optional.ofNullable(clazz.cast(this.referenceArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "readSetId": {
                return Optional.ofNullable(clazz.cast(this.readSetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFiles", SOURCE_FILES_FIELD);
        map.put("sourceFileType", SOURCE_FILE_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("subjectId", SUBJECT_ID_FIELD);
        map.put("sampleId", SAMPLE_ID_FIELD);
        map.put("generatedFrom", GENERATED_FROM_FIELD);
        map.put("referenceArn", REFERENCE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("readSetId", READ_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportReadSetSourceItem, T> g) {
        return obj -> g.apply((ImportReadSetSourceItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SourceFiles sourceFiles;
        private String sourceFileType;
        private String status;
        private String statusMessage;
        private String subjectId;
        private String sampleId;
        private String generatedFrom;
        private String referenceArn;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String readSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportReadSetSourceItem model) {
            this.sourceFiles(model.sourceFiles);
            this.sourceFileType(model.sourceFileType);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.subjectId(model.subjectId);
            this.sampleId(model.sampleId);
            this.generatedFrom(model.generatedFrom);
            this.referenceArn(model.referenceArn);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.readSetId(model.readSetId);
        }

        public final SourceFiles.Builder getSourceFiles() {
            return this.sourceFiles != null ? this.sourceFiles.toBuilder() : null;
        }

        public final void setSourceFiles(SourceFiles.BuilderImpl sourceFiles) {
            this.sourceFiles = sourceFiles != null ? sourceFiles.build() : null;
        }

        @Override
        public final Builder sourceFiles(SourceFiles sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        public final String getSourceFileType() {
            return this.sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetImportJobItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getSubjectId() {
            return this.subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return this.sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getGeneratedFrom() {
            return this.generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getReferenceArn() {
            return this.referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getReadSetId() {
            return this.readSetId;
        }

        public final void setReadSetId(String readSetId) {
            this.readSetId = readSetId;
        }

        @Override
        public final Builder readSetId(String readSetId) {
            this.readSetId = readSetId;
            return this;
        }

        public ImportReadSetSourceItem build() {
            return new ImportReadSetSourceItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportReadSetSourceItem> {
        public Builder sourceFiles(SourceFiles var1);

        default public Builder sourceFiles(Consumer<SourceFiles.Builder> sourceFiles) {
            return this.sourceFiles((SourceFiles)((SourceFiles.Builder)SourceFiles.builder().applyMutation(sourceFiles)).build());
        }

        public Builder sourceFileType(String var1);

        public Builder sourceFileType(FileType var1);

        public Builder status(String var1);

        public Builder status(ReadSetImportJobItemStatus var1);

        public Builder statusMessage(String var1);

        public Builder subjectId(String var1);

        public Builder sampleId(String var1);

        public Builder generatedFrom(String var1);

        public Builder referenceArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder readSetId(String var1);
    }
}

