/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.VariantStoreItem;

public class ListVariantStoresPublisher
implements SdkPublisher<ListVariantStoresResponse> {
    private final OmicsAsyncClient client;
    private final ListVariantStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVariantStoresPublisher(OmicsAsyncClient client, ListVariantStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVariantStoresPublisher(OmicsAsyncClient client, ListVariantStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVariantStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVariantStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VariantStoreItem> variantStores() {
        Function<ListVariantStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.variantStores() != null) {
                return response.variantStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVariantStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVariantStoresResponseFetcher
    implements AsyncPageFetcher<ListVariantStoresResponse> {
        private ListVariantStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListVariantStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVariantStoresResponse> nextPage(ListVariantStoresResponse previousPage) {
            if (previousPage == null) {
                return ListVariantStoresPublisher.this.client.listVariantStores(ListVariantStoresPublisher.this.firstRequest);
            }
            return ListVariantStoresPublisher.this.client.listVariantStores((ListVariantStoresRequest)((Object)ListVariantStoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

