/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.IAMFederationOptionsOutput;
import software.amazon.awssdk.services.opensearch.model.JWTOptionsOutput;
import software.amazon.awssdk.services.opensearch.model.SAMLOptionsOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedSecurityOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedSecurityOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::enabled)).setter(AdvancedSecurityOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InternalUserDatabaseEnabled").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::internalUserDatabaseEnabled)).setter(AdvancedSecurityOptions.setter(Builder::internalUserDatabaseEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled").build()}).build();
    private static final SdkField<SAMLOptionsOutput> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SAMLOptions").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::samlOptions)).setter(AdvancedSecurityOptions.setter(Builder::samlOptions)).constructor(SAMLOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLOptions").build()}).build();
    private static final SdkField<JWTOptionsOutput> JWT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JWTOptions").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::jwtOptions)).setter(AdvancedSecurityOptions.setter(Builder::jwtOptions)).constructor(JWTOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JWTOptions").build()}).build();
    private static final SdkField<IAMFederationOptionsOutput> IAM_FEDERATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IAMFederationOptions").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::iamFederationOptions)).setter(AdvancedSecurityOptions.setter(Builder::iamFederationOptions)).constructor(IAMFederationOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMFederationOptions").build()}).build();
    private static final SdkField<Instant> ANONYMOUS_AUTH_DISABLE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AnonymousAuthDisableDate").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::anonymousAuthDisableDate)).setter(AdvancedSecurityOptions.setter(Builder::anonymousAuthDisableDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousAuthDisableDate").build()}).build();
    private static final SdkField<Boolean> ANONYMOUS_AUTH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AnonymousAuthEnabled").getter(AdvancedSecurityOptions.getter(AdvancedSecurityOptions::anonymousAuthEnabled)).setter(AdvancedSecurityOptions.setter(Builder::anonymousAuthEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousAuthEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INTERNAL_USER_DATABASE_ENABLED_FIELD, SAML_OPTIONS_FIELD, JWT_OPTIONS_FIELD, IAM_FEDERATION_OPTIONS_FIELD, ANONYMOUS_AUTH_DISABLE_DATE_FIELD, ANONYMOUS_AUTH_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdvancedSecurityOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean internalUserDatabaseEnabled;
    private final SAMLOptionsOutput samlOptions;
    private final JWTOptionsOutput jwtOptions;
    private final IAMFederationOptionsOutput iamFederationOptions;
    private final Instant anonymousAuthDisableDate;
    private final Boolean anonymousAuthEnabled;

    private AdvancedSecurityOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.samlOptions = builder.samlOptions;
        this.jwtOptions = builder.jwtOptions;
        this.iamFederationOptions = builder.iamFederationOptions;
        this.anonymousAuthDisableDate = builder.anonymousAuthDisableDate;
        this.anonymousAuthEnabled = builder.anonymousAuthEnabled;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean internalUserDatabaseEnabled() {
        return this.internalUserDatabaseEnabled;
    }

    public final SAMLOptionsOutput samlOptions() {
        return this.samlOptions;
    }

    public final JWTOptionsOutput jwtOptions() {
        return this.jwtOptions;
    }

    public final IAMFederationOptionsOutput iamFederationOptions() {
        return this.iamFederationOptions;
    }

    public final Instant anonymousAuthDisableDate() {
        return this.anonymousAuthDisableDate;
    }

    public final Boolean anonymousAuthEnabled() {
        return this.anonymousAuthEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamFederationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.anonymousAuthDisableDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.anonymousAuthEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityOptions)) {
            return false;
        }
        AdvancedSecurityOptions other = (AdvancedSecurityOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled()) && Objects.equals(this.samlOptions(), other.samlOptions()) && Objects.equals(this.jwtOptions(), other.jwtOptions()) && Objects.equals(this.iamFederationOptions(), other.iamFederationOptions()) && Objects.equals(this.anonymousAuthDisableDate(), other.anonymousAuthDisableDate()) && Objects.equals(this.anonymousAuthEnabled(), other.anonymousAuthEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"AdvancedSecurityOptions").add("Enabled", (Object)this.enabled()).add("InternalUserDatabaseEnabled", (Object)this.internalUserDatabaseEnabled()).add("SAMLOptions", (Object)this.samlOptions()).add("JWTOptions", (Object)this.jwtOptions()).add("IAMFederationOptions", (Object)this.iamFederationOptions()).add("AnonymousAuthDisableDate", (Object)this.anonymousAuthDisableDate()).add("AnonymousAuthEnabled", (Object)this.anonymousAuthEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "InternalUserDatabaseEnabled": {
                return Optional.ofNullable(clazz.cast(this.internalUserDatabaseEnabled()));
            }
            case "SAMLOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
            case "JWTOptions": {
                return Optional.ofNullable(clazz.cast(this.jwtOptions()));
            }
            case "IAMFederationOptions": {
                return Optional.ofNullable(clazz.cast(this.iamFederationOptions()));
            }
            case "AnonymousAuthDisableDate": {
                return Optional.ofNullable(clazz.cast(this.anonymousAuthDisableDate()));
            }
            case "AnonymousAuthEnabled": {
                return Optional.ofNullable(clazz.cast(this.anonymousAuthEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("InternalUserDatabaseEnabled", INTERNAL_USER_DATABASE_ENABLED_FIELD);
        map.put("SAMLOptions", SAML_OPTIONS_FIELD);
        map.put("JWTOptions", JWT_OPTIONS_FIELD);
        map.put("IAMFederationOptions", IAM_FEDERATION_OPTIONS_FIELD);
        map.put("AnonymousAuthDisableDate", ANONYMOUS_AUTH_DISABLE_DATE_FIELD);
        map.put("AnonymousAuthEnabled", ANONYMOUS_AUTH_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityOptions, T> g) {
        return obj -> g.apply((AdvancedSecurityOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean internalUserDatabaseEnabled;
        private SAMLOptionsOutput samlOptions;
        private JWTOptionsOutput jwtOptions;
        private IAMFederationOptionsOutput iamFederationOptions;
        private Instant anonymousAuthDisableDate;
        private Boolean anonymousAuthEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityOptions model) {
            this.enabled(model.enabled);
            this.internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            this.samlOptions(model.samlOptions);
            this.jwtOptions(model.jwtOptions);
            this.iamFederationOptions(model.iamFederationOptions);
            this.anonymousAuthDisableDate(model.anonymousAuthDisableDate);
            this.anonymousAuthEnabled(model.anonymousAuthEnabled);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return this.internalUserDatabaseEnabled;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final SAMLOptionsOutput.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SAMLOptionsOutput.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SAMLOptionsOutput samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final JWTOptionsOutput.Builder getJwtOptions() {
            return this.jwtOptions != null ? this.jwtOptions.toBuilder() : null;
        }

        public final void setJwtOptions(JWTOptionsOutput.BuilderImpl jwtOptions) {
            this.jwtOptions = jwtOptions != null ? jwtOptions.build() : null;
        }

        @Override
        public final Builder jwtOptions(JWTOptionsOutput jwtOptions) {
            this.jwtOptions = jwtOptions;
            return this;
        }

        public final IAMFederationOptionsOutput.Builder getIamFederationOptions() {
            return this.iamFederationOptions != null ? this.iamFederationOptions.toBuilder() : null;
        }

        public final void setIamFederationOptions(IAMFederationOptionsOutput.BuilderImpl iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions != null ? iamFederationOptions.build() : null;
        }

        @Override
        public final Builder iamFederationOptions(IAMFederationOptionsOutput iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions;
            return this;
        }

        public final Instant getAnonymousAuthDisableDate() {
            return this.anonymousAuthDisableDate;
        }

        public final void setAnonymousAuthDisableDate(Instant anonymousAuthDisableDate) {
            this.anonymousAuthDisableDate = anonymousAuthDisableDate;
        }

        @Override
        public final Builder anonymousAuthDisableDate(Instant anonymousAuthDisableDate) {
            this.anonymousAuthDisableDate = anonymousAuthDisableDate;
            return this;
        }

        public final Boolean getAnonymousAuthEnabled() {
            return this.anonymousAuthEnabled;
        }

        public final void setAnonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
        }

        @Override
        public final Builder anonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
            return this;
        }

        public AdvancedSecurityOptions build() {
            return new AdvancedSecurityOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedSecurityOptions> {
        public Builder enabled(Boolean var1);

        public Builder internalUserDatabaseEnabled(Boolean var1);

        public Builder samlOptions(SAMLOptionsOutput var1);

        default public Builder samlOptions(Consumer<SAMLOptionsOutput.Builder> samlOptions) {
            return this.samlOptions((SAMLOptionsOutput)((SAMLOptionsOutput.Builder)SAMLOptionsOutput.builder().applyMutation(samlOptions)).build());
        }

        public Builder jwtOptions(JWTOptionsOutput var1);

        default public Builder jwtOptions(Consumer<JWTOptionsOutput.Builder> jwtOptions) {
            return this.jwtOptions((JWTOptionsOutput)((JWTOptionsOutput.Builder)JWTOptionsOutput.builder().applyMutation(jwtOptions)).build());
        }

        public Builder iamFederationOptions(IAMFederationOptionsOutput var1);

        default public Builder iamFederationOptions(Consumer<IAMFederationOptionsOutput.Builder> iamFederationOptions) {
            return this.iamFederationOptions((IAMFederationOptionsOutput)((IAMFederationOptionsOutput.Builder)IAMFederationOptionsOutput.builder().applyMutation(iamFederationOptions)).build());
        }

        public Builder anonymousAuthDisableDate(Instant var1);

        public Builder anonymousAuthEnabled(Boolean var1);
    }
}

